package gov.va.med.ccht.ui.ajax;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
//import org.springframework.web.servlet.view.json.MappingJacksonJsonView;

@Component
public class AjaxRequestHandler {

	public static final String AJAX_RESULT_MODEL_KEY = "ajaxResult";
	public static final String AJAX_STATUS_MESSAGE_KEY = "statusMessage";
	public static final String AJAX_STATUS_DETAILS_KEY = "statusDetails";
	public static final String AJAX_ERROR_STATUS_KEY = "hasError";

	private Logger logger = Logger.getLogger(getClass());
	
	@Autowired
	protected MessageSource messageSource;

	/**
	 * Utility method which returns true iff the HttpServletRequest was an AJAX
	 * request
	 * 
	 * @param r
	 * @return
	 */
	public static boolean isAjax(HttpServletRequest r) {
		return r.getServletPath().equals("/ajax");
	}

//	public MappingJacksonJsonView createView(boolean skipAjaxResultJSONWrapper) {
//		ObjectMapper om = new ObjectMapper();
//		MappingJacksonJsonView v = new MappingJacksonJsonView();
//		v.setObjectMapper(om);
//		v.setBeanName(AJAX_RESULT_MODEL_KEY);
//		// v.setContentType("text/html;charset=UTF-8");
//		return v;
//	}

	public ModelAndView getExceptionModelAndView(Throwable ex, HttpServletRequest request) {
		if (!isAjax(request))
			throw new IllegalArgumentException(
					"The specified " + HttpServletRequest.class.getSimpleName() + " was not an AJAX request");

		logger.error("$$$$$$$ fix me.");
		
//		MappingJacksonJsonView jsonView = createView(false);

		Map<String, Object> model = new HashMap<>();
		populateResponseForAjaxException(model, ex);

		ModelAndView mav = new ModelAndView();
//		mav.setView(jsonView);
		mav.addObject(AJAX_RESULT_MODEL_KEY, model);
		return mav;
	}

	private void populateAjaxMap(MessageSourceResolvable e, Map<String, Object> retMap) {
		retMap.put(AJAX_STATUS_MESSAGE_KEY, messageSource.getMessage(e, Locale.getDefault()));
	}

	private void populateResponseForAjaxException(Map<String, Object> retMap, Throwable e) {
		if (e instanceof MessageSourceResolvable) {
			populateAjaxMap((MessageSourceResolvable) e, retMap);
		} else {
			retMap.put(AJAX_STATUS_MESSAGE_KEY, e.getMessage());
			retMap.put(AJAX_STATUS_DETAILS_KEY, ExceptionUtils.getStackTrace(e));
		}
		retMap.put(AJAX_ERROR_STATUS_KEY, true);
	}

}
