package gov.va.med.ccht.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;

public class CchtRequestHeaderAuthenticationFilter extends RequestHeaderAuthenticationFilter {

	private List<String> excludedPrefixes = new ArrayList<String>();
	
	public CchtRequestHeaderAuthenticationFilter() {
		this.setExceptionIfHeaderMissing(false);
	}
	
	@Override
	protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
		String preauthUsername = System.getenv("ccht.preauth.username"); // is the user already logged in.
		if (StringUtils.isNotBlank(preauthUsername))
			return preauthUsername;
		return super.getPreAuthenticatedPrincipal(request);
	}

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        if (request instanceof HttpServletRequest == false) {
            super.doFilter(request, response, chain);
            return;
        }

        HttpServletRequest hsr = (HttpServletRequest) request;
        for (String excludedPrefix : excludedPrefixes) {
            if (hsr.getServletPath().startsWith(excludedPrefix)) {
                chain.doFilter(request, response);
                return;
            }
        }
        super.doFilter(request, response, chain);
    }

	public List<String> getExcludedPrefixes() {
		return excludedPrefixes;
	}

	public void setExcludedPrefixes(List<String> excludedPrefixes) {
		this.excludedPrefixes = excludedPrefixes;
	}


}
