// Package 
package gov.va.med.ccht.service.report;

// Java Classes
import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

import gov.va.med.ccht.model.terminology.ReportType;
import gov.va.med.ccht.model.terminology.StandardReport;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.security.UserPrincipal;

/**
 * 
 * @author DNS
 *
 */
public class ReportFilterSearchQueryInfo implements Serializable {
	private static final long serialVersionUID = 3965263461783639160L;
	private ReportType reportType = null;
	private StandardReport standardReport = null;
	private ReportExportedType reportExportedType = null;
	private Date dateFrom = null;
	private Date dateTo = null;
	private UserPrincipal user = null;

	public ReportType getReportType() {
		return reportType;
	}

	public void setReportType(ReportType reportType) {
		this.reportType = reportType;
	}

	public StandardReport getStandardReport() {
		return standardReport;
	}

	public void setStandardReport(StandardReport standardReport) {
		this.standardReport = standardReport;
	}

	public ReportExportedType getReportExportedType() {
		return reportExportedType;
	}

	public void setReportExportedType(ReportExportedType reportExportedType) {
		this.reportExportedType = reportExportedType;
	}

	public UserPrincipal getUser() {
		return user;
	}

	public void setUser(UserPrincipal user) {
		this.user = user;
	}

	public Date getDateFrom() {
		return dateFrom;
	}

	public void setDateFrom(Date dateFrom) {
		this.dateFrom = dateFrom;
	}

	public Date getDateTo() {
		return dateTo;
	}

	public void setDateTo(Date dateTo) {
		this.dateTo = dateTo;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("reportType", getReportType());
		builder.append("standardReport", getStandardReport());
		builder.append("reportExportedType", getReportExportedType());
		builder.append("dateFrom", getDateFrom());
		builder.append("dateTo", getDateTo());
		builder.append("user", getUser());
	}
}
