package gov.va.med.ccht.service.qir;

import java.util.Date;
import java.util.List;

import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRAttachment;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.model.qir.QIRSearchResult;
import gov.va.med.ccht.model.qir.QIRStatusType;
import gov.va.med.fw.service.ServiceException;

public interface QIRService {

	public List<QIRSearchResult> searchQIR(QIRSearchParameters qirSearchParameters) throws ServiceException;

	public List<QIRStatusType> getAllQIRStatusTypes();
	
	public QIR getQIR(long id) throws ServiceException;

	public void updateQIR(QIR qir) throws ServiceException;

	public void updateQIRAttachment(QIRAttachment qirAttachment) throws ServiceException;

	public void deleteQIRAttachment(long qirAttachmentId) throws ServiceException;

	public QIRAttachment getQIRAttachment(long qirAttachmentId) throws ServiceException;

	public Integer generateVendorResponseDueNotifications() throws ServiceException;

	public void sendVendorResponseDueEMail(String qirId) throws ServiceException;

	public QIR saveQIR(QIR qir) throws ServiceException;

	public Date getDueDateFromHistory(String qirId) throws ServiceException;
	
	public QIRStatusType findQIRStatusTypeByName(String name);

}
