package gov.va.med.ccht.service.htreports.impl;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.pssreport.CategoryOfCare;
import gov.va.med.ccht.model.pssreport.DistributionOfSurveysReport;
import gov.va.med.ccht.model.pssreport.SurveyTrendChartResult;
import gov.va.med.ccht.model.pssreport.VendorSubmissionReportData;
import gov.va.med.ccht.model.report.DeviceModality;
import gov.va.med.ccht.model.satisfactionsurvey.SatisfactionSurveyQuestionResult;
import gov.va.med.ccht.persistent.DeviceModalityDAO;
import gov.va.med.ccht.persistent.PssDistributionReportDAO;
import gov.va.med.ccht.persistent.SatisfactionSurveyReportDAO;
import gov.va.med.ccht.persistent.SurveyTrendChartsDAO;
import gov.va.med.ccht.persistent.VendorSubmissionReportDAO;
import gov.va.med.ccht.service.htreports.PssReportService;
import gov.va.med.ccht.ui.model.PSSReportForm;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;


@Service
public class PssReportServiceImpl implements PssReportService {

	@Autowired
	private VendorSubmissionReportDAO vendorSubmissionReportDAO;
	@Autowired
	private PssDistributionReportDAO pssDistributionReportDAO;
	@Autowired
	private SatisfactionSurveyReportDAO satisfactionSurveyReportDAO;
	@Autowired
	private DeviceModalityDAO deviceModalityDao;
	@Autowired
	private SurveyTrendChartsDAO surveyTrendChartsDAO;
	
	
	@Override
	public LinkedList<SurveyTrendChartResult> getSurveyTrendChartsReportData(PSSReportForm form) 
	{
		return surveyTrendChartsDAO.getSurveyTrendChartsReportData(form);
	};
	
	@Override
	public List<VendorSubmissionReportData> getVendorSubmissionReport() 
	{
		return vendorSubmissionReportDAO.getVendorSubmissionReport();
	}

	@Override
	public DistributionOfSurveysReport getDistributionNationalReport(PSSReportForm form) 
	{
		return pssDistributionReportDAO.getNationalReport(form);
	}
	
	@Override
	public DistributionOfSurveysReport getDistributionVisnReport(PSSReportForm form) 
	{
		return pssDistributionReportDAO.getVisnReport(form);
	}
	
	@Override
	public DistributionOfSurveysReport getDistributionFacilityReport(PSSReportForm form) 
	{
		return pssDistributionReportDAO.getFacilityReport(form);
	}
	
	@Override
	public List<CategoryOfCare> getCategoriesOfCare() {
		return satisfactionSurveyReportDAO.getCategoriesOfCare();
	}
	
	@Override
	public List<Date> getDatesByMonth() {
		return satisfactionSurveyReportDAO.getDatesByMonth();
	}
	
	@Override
	public List<SatisfactionSurveyQuestionResult> getSatisfactionSurveyReport(PSSReportForm form) throws NumberFormatException, DAOException, ServiceException {
		return satisfactionSurveyReportDAO.getSatisfactionSurveyReport(form);
	}
	
	@Override
	public List<DeviceModality> getAllDeviceModalities() {
		return deviceModalityDao.getAllDeviceModalities();
	}
	
	@Override
	public DeviceModality getModalityByName(String name) {
		return deviceModalityDao.getModalityByName(name);
	}
	
	@Override
	public DeviceModality getModalityById(Long id) {
		return deviceModalityDao.getModalityById(id);
	}
}
