package gov.va.med.ccht.service.htreports;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.pssreport.CategoryOfCare;
import gov.va.med.ccht.model.pssreport.DistributionOfSurveysReport;
import gov.va.med.ccht.model.pssreport.SurveyTrendChartResult;
import gov.va.med.ccht.model.pssreport.VendorSubmissionReportData;
import gov.va.med.ccht.model.report.DeviceModality;
import gov.va.med.ccht.model.satisfactionsurvey.SatisfactionSurveyQuestionResult;
import gov.va.med.ccht.ui.model.PSSReportForm;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

/**
 * Combined service for All Patient Satisfaction Reports including:
 * Vendor Submissions
 * Survey Trend Charts
 * Distribution of Surveys
 * Statistics for Patient Satisfaction
 * ...
 * as well as other required database methods
 * @author DNS
 *
 */
@Service
public interface PssReportService {

	public List<VendorSubmissionReportData> getVendorSubmissionReport();
	
	public DistributionOfSurveysReport getDistributionNationalReport(PSSReportForm form);
	
	public DistributionOfSurveysReport getDistributionVisnReport(PSSReportForm form);
	
	public DistributionOfSurveysReport getDistributionFacilityReport(PSSReportForm form);
	
	public List<CategoryOfCare> getCategoriesOfCare();
	
	public List<Date> getDatesByMonth();
	
	public List<SatisfactionSurveyQuestionResult> getSatisfactionSurveyReport(PSSReportForm form) throws NumberFormatException, DAOException, ServiceException;
	
	public List<DeviceModality> getAllDeviceModalities();

	public DeviceModality getModalityByName(String name);
	
	public DeviceModality getModalityById(Long id);

	public LinkedList<SurveyTrendChartResult> getSurveyTrendChartsReportData(PSSReportForm form);
}
