package gov.va.med.ccht.service.htreports;


import java.text.ParseException;
import java.util.Date;
import java.util.List;

import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.ccht.model.car.CensusActivityVisnRecord;
import gov.va.med.ccht.model.report.AggregateModality;
import gov.va.med.ccht.ui.model.CensusActivityReportForm;
import gov.va.med.fw.service.ServiceException;

public interface CensusActivityReportService 
{	
	public CensusActivityRecord getAllVendorsReportStatus() throws ServiceException;
	
	public String getHdrEndpoint();
	public void setHdrEndpoint(String hdrEndpoint);
	
	public List<CensusActivityRecord> getNationalReport(CensusActivityReportForm form)throws ServiceException, ParseException;
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(CensusActivityReportForm form)throws ServiceException, ParseException;
	public List<CensusActivityVisnRecord> getVisnReport(CensusActivityReportForm form)throws ServiceException, ParseException;
	public List<CensusActivityVisnRecord> getSubtotaledVisnReport(CensusActivityReportForm form)throws ServiceException, ParseException;
	public List<CensusActivityVisnRecord> getVisnDrilldownData(CensusActivityReportForm form) throws ServiceException;
	public List<CensusActivityVisnRecord> getSubtotaledFacilityReport(CensusActivityReportForm form) throws ServiceException;
	public Date getMinStartDate() throws ServiceException;
	public AggregateModality getModalityByCode(String code) throws ServiceException;
}