package gov.va.med.ccht.service.common.visn.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Visn;
import gov.va.med.ccht.persistent.VisnDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.common.visn.VisnService;
import gov.va.med.fw.service.ServiceException;

@Service
public class VisnServiceImpl  extends AbstractBusinessService implements VisnService {

	@Autowired
	private VisnDAO visnDao;
	
	@Override
	public List<Visn> getVisns() throws ServiceException {
		try {
			return visnDao.getVisns();
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public Visn getVisn(String name) throws ServiceException {
		try {
			return visnDao.getVisn(name);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public SimpleVisn getSimpleVisn(String name) throws ServiceException {
		try {
			return visnDao.getSimpleVisn(name);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public List<SimpleVisn> getSimpleVisns() throws ServiceException {
		try {
			List<SimpleVisn> list = visnDao.getSimpleVisns();
			return list;
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public Visn getVisnById(Long id) throws ServiceException {
		try {
			return visnDao.getVisnById(id);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

}
