/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common.impl;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.AppUserGroup;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserPreference;
import gov.va.med.ccht.model.UserRole;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRRemarks;
import gov.va.med.ccht.model.qir.QIRSimpleAttachment;
import gov.va.med.ccht.model.qir.QIRVendorAction;
import gov.va.med.ccht.service.common.MergeService;
import gov.va.med.fw.conversion.CopyService;
import gov.va.med.fw.rule.MatchRuleService;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

/**
 * @author DNS
 * 
 */
@SuppressWarnings("deprecation")
@Service
public class MergeServiceImpl extends AbstractComponent implements MergeService {

	private static final long serialVersionUID = 5352060928847324634L;
	
	@Autowired
	private CopyService copyService = null;
	@Autowired
	private MatchRuleService matchRuleService = null;

	@Override
	public QIR mergeQIR(QIR incoming, QIR onFile) throws ServiceException {
		// copy editable properties
		onFile.setQirType(incoming.getQirType());
		onFile.setQirStatusType(incoming.getQirStatusType());			
		onFile.setVisn(incoming.getVisn());
		onFile.setFacility(incoming.getFacility());			
		onFile.setDeviceType(incoming.getDeviceType());
		onFile.setVendor(incoming.getVendor());			
		onFile.setSerialNumber(incoming.getSerialNumber());
		onFile.setPurchaseOrderNumber(incoming.getPurchaseOrderNumber());
		onFile.setSubmittedDate(incoming.getSubmittedDate());
		onFile.setVendorResponseDueDate(incoming.getVendorResponseDueDate());
		onFile.setEmailReminderSentDate(incoming.getEmailReminderSentDate());
		onFile.setStatusChangeDate(incoming.getStatusChangeDate());
		onFile.setComplaint(incoming.getComplaint());
		onFile.setSummary(incoming.getSummary());
		onFile.setSubmittedBy(incoming.getSubmittedBy());
		onFile.setIsDmpIssue(incoming.getIsDmpIssue());
		onFile.setDmpQirType(incoming.getDmpQirType());
		//copy internal sets
		mergeQIRRemarks(incoming, onFile);
		mergeQIRVendorActions(incoming, onFile);
		mergeQIRAttachments(incoming, onFile);
		return null;
	}
	
	public Role mergeRole(Role incoming, Role onFile) throws ServiceException {
		
		incoming.getPermissions().forEach(permission -> {
			onFile.getPermissions().add(permission);
		});
		
		return onFile;
	}

	public User mergeUser(User incoming, User onFile) throws ServiceException {
		
		//groups
		mergeUserGroups(incoming, onFile);
		//roles
		mergeRoles(incoming, onFile);
		//preferences
		mergePreferences(incoming, onFile);
		return onFile;
	}

	private void mergeUserGroups(User incoming, User onFile) throws ServiceException {
		
		final Set<AppUserGroup> groups = new HashSet<AppUserGroup>();
		groups.addAll(incoming.getUserGroups());
		groups.addAll(onFile.getUserGroups());
		
		groups.forEach(group -> {
			onFile.removeUserGroup(group);
			onFile.addUserGroup(group);
		});
		
	}
	
	private void mergePreferences(User incoming, User onFile) throws ServiceException {
		
		final Set<UserPreference> prefs = new HashSet<UserPreference>();
		prefs.addAll(incoming.getPreferencees());
		prefs.addAll(onFile.getPreferencees());
		
		prefs.forEach(pref -> {
			onFile.removePreference(pref);
			onFile.addPreference(pref);
		});
		
	}
	
	private void mergeRoles(User incoming, User onFile) throws ServiceException {
		
		final Set<UserRole> roles = new HashSet<UserRole>();
		roles.addAll(incoming.getRoles());
		roles.addAll(onFile.getRoles());
		
		roles.forEach(role -> {
			onFile.addRole(role);
			onFile.removeRole(role);
		});
		
	}
	
	private void mergeQIRRemarks(QIR incoming, QIR onFile) throws ServiceException {		
		for (QIRRemarks remarks:incoming.getRemarks()) {
			if (remarks.getId() == null) {
				onFile.addRemarks(remarks);
			}
		}
	}
	private void mergeQIRVendorActions(QIR incoming, QIR onFile) throws ServiceException {		
		for (QIRVendorAction actions:incoming.getVendorActions()) {
			if (actions.getId() == null) {
				onFile.addVendorActions(actions);
			}
		}
	}
	private void mergeQIRAttachments(QIR incoming, QIR onFile) throws ServiceException {		
		for (QIRSimpleAttachment attachment:incoming.getAttachments()) {
			if (attachment.getId() == null) {
				onFile.addAttachment(attachment);
			}
		}
	}
	
	/**
	 * @return the copyService
	 */
	public CopyService getCopyService() {
		return copyService;
	}

	/**
	 * @param copyService
	 *            the copyService to set
	 */
	public void setCopyService(CopyService copyService) {
		this.copyService = copyService;
	}

	/**
	 * @return the matchRuleService
	 */
	public MatchRuleService getMatchRuleService() {
		return matchRuleService;
	}

	/**
	 * @param matchRuleService
	 *            the matchRuleService to set
	 */
	public void setMatchRuleService(MatchRuleService matchRuleService) {
		this.matchRuleService = matchRuleService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	@Override
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		// validate for required services
		Validate.notNull(copyService, "CopyService required for MergeService");
		Validate.notNull(matchRuleService, "MatchRuleService required for MergeService");
	}


}
