/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common.impl;

import java.util.TimeZone;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import gov.va.med.ccht.service.common.DeployedEnvironment;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.config.EnvironmentParamService;
import gov.va.med.fw.util.VersionInfo;

/**
 * used 
 * @author DNS
 */
@Component
public class EnvironmentParamServiceImpl extends AbstractComponent implements
		EnvironmentParamService {

	@Autowired
	private VersionInfo version = null;
	private TimeZone reportingTimeZone = null;
	private boolean isDataClean = false;
	private String ldapGroupsRoot = null;	
	
	@Value("${ccht.env}")
	private String env;
	
	@Value("${logout.timeout.url}")
	private String logoutTimeoutUrl;
	
	@Value("${logout.manual.url}")
	private String logoutManualUrl;

	public VersionInfo getVersion() {
		return version;
	}

	public void setVersion(VersionInfo version) {
		this.version = version;
	}

	public TimeZone getReportingTimeZone() {
		return reportingTimeZone;
	}

	public void setReportingTimeZone(TimeZone reportingTimeZone) {
		this.reportingTimeZone = reportingTimeZone;
	}

	public String getLdapGroupsRoot() {
		return ldapGroupsRoot;
	}

	public void setLdapGroupsRoot(String ldapGroupsRoot) {
		this.ldapGroupsRoot = ldapGroupsRoot;
	}

	public boolean isDataClean() {
		return isDataClean;
	}

	public boolean isDevIntEnv() {
		return DeployedEnvironment.DEVINT.getKey().equalsIgnoreCase(env);
	}

	public boolean isSqaEnv() {
		return DeployedEnvironment.SQA.getKey().equalsIgnoreCase(env);
	}

	public boolean isProdEnv() {
		return DeployedEnvironment.PROD.getKey().equalsIgnoreCase(env);
	}

	public boolean isLocalEnv() {
		return DeployedEnvironment.LOCAL.getKey().equalsIgnoreCase(env);
	}

	public String getDeployedEnvironment() {
		return env;
	}

	public void setIsDataClean(boolean isDataClean) {
		this.isDataClean = isDataClean;
	}

	public void setEnv(String env) {
		this.env = env;
	}

	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
	}
	
	public String getLogoutTimeoutUrl() {
		return logoutTimeoutUrl;
	}

	public void setLogoutTimeoutUrl(String logoutTimeoutUrl) {
		this.logoutTimeoutUrl = logoutTimeoutUrl;
	}

	public String getLogoutManualUrl() {
		return logoutManualUrl;
	}
 
	public void setLogoutManualUrl(String logoutManualUrl) {
		this.logoutManualUrl = logoutManualUrl;
	}
}
