package gov.va.med.ccht.service.common.facility.impl;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.common.Facility;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.persistent.FacilityDAO;
import gov.va.med.ccht.service.common.facility.FacilityService;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.fw.service.ServiceException;

@Service
public class FacilityServiceImpl extends AbstractBusinessService implements FacilityService {

	@Autowired
	private FacilityDAO facilityDao;
	
	@Override
	public SortedSet<Facility> getFacilities() throws ServiceException {
		try {
			return new TreeSet<>(facilityDao.getFacilities());
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public SortedSet<Facility> getFacilities(String visnName) throws ServiceException {
		try {
			return new TreeSet<>(facilityDao.getFacilities(visnName));
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public Facility getFacility(String stationNumber) throws ServiceException {
		try {
			return facilityDao.getFacility(stationNumber);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public Facility getFacilityById(Long id) throws ServiceException {
		try {
			return facilityDao.getFacilityById(id);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public SimpleFacility getSimpleFacility(String stationNumber) throws ServiceException {
		try {
			return facilityDao.getSimpleFacility(stationNumber);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public SortedSet<SimpleFacility> getSortedSimpleFacilities() throws ServiceException {
		try {
			
			return new TreeSet<>(facilityDao.getSortedSimpleFacilities());
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public SortedSet<SimpleFacility> getSimpleFacilities() throws ServiceException {
		try {
			
			return new TreeSet<>(facilityDao.getSimpleFacilities());
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}


	@Override
	public SortedSet<SimpleFacility> getSimpleFacilities(SimpleVisn visn) throws ServiceException {
		try {
			List<SimpleFacility> list = facilityDao.getSimpleFacilities(visn);
			return new TreeSet<>(list);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

}
