package gov.va.med.ccht.service.common.facility;

import java.util.SortedSet;

import gov.va.med.ccht.model.common.Facility;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.fw.service.ServiceException;

public interface FacilityService {
	
	public SortedSet<Facility> getFacilities() throws ServiceException;

	public SortedSet<Facility> getFacilities(String visnName) throws ServiceException;
	
	public Facility getFacility(String stationNumber) throws ServiceException;
	
	public Facility getFacilityById(Long id) throws ServiceException;
	
	public SimpleFacility getSimpleFacility(String stationNumber) throws ServiceException;

	public SortedSet<SimpleFacility> getSortedSimpleFacilities() throws ServiceException;

	public SortedSet<SimpleFacility> getSimpleFacilities() throws ServiceException;

	public SortedSet<SimpleFacility> getSimpleFacilities(SimpleVisn visn) throws ServiceException;

}
