package gov.va.med.ccht.service.common.device.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ccht.model.common.Device;
import gov.va.med.ccht.model.common.DeviceType;
import gov.va.med.ccht.persistent.DeviceDAO;
import gov.va.med.ccht.service.common.device.DeviceService;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.fw.service.ServiceException;

@Service
public class DeviceServiceImpl extends AbstractBusinessService implements DeviceService {

	@Autowired
	private DeviceDAO deviceDao;
	
	@Override
	public List<Device> getDevices() throws ServiceException {
		try {
			return deviceDao.getDevices();
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public Device getDevice(String name) throws ServiceException {
		try {
			return deviceDao.getDevice(name);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	

	@Override
	public DeviceType getDeviceType(String code) throws ServiceException {
		try {
			return deviceDao.getDeviceType(code);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	/*
	 * 
	 * TODO: THE FOLLOWING COMMENTED BLOCK COULD BE RE-INTRODUCED BASED ON NEEDS YET
	 * TO BE DETERMINED ONCE WE START IMPLEMENTING REPORTS.
	@Override
	public DeviceDetail getDeviceDetail(int id) {
		return deviceDao.findDeviceDetail(id);
	}

	@Override
	public DeviceDetail getDeviceDetail(DeviceSearchParameters deviceSearchParameters) throws ServiceException {
		try {
			return deviceDao.getDeviceDetail(deviceSearchParameters);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public void updateDeviceDetail(DeviceDetail deviceDetail) throws ServiceException {
		deviceDao.updateDeviceDetail(deviceDetail);
	}

	@Override
	public DeviceRequirement getDeviceRequirement(int id) {
		return deviceDao.getDeviceRequirement(id);
	}

	@Override
	public List<DeviceRequirement> getDeviceRequirements(SimpleFacility simpleFacility) throws ServiceException {
		try {
			return deviceDao.getDeviceRequirements(simpleFacility);
		} catch (Exception e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public List<DeviceRequirement> updateDeviceRequirements(List<DeviceRequirement> deviceRequirements) {
		deviceDao.updateDeviceRequirements(deviceRequirements);
		return deviceRequirements;
	}
	
	@Override
	public List<Object[]> searchDevice(DeviceSearchParameters deviceSearchParameters) throws ServiceException {
		try {
			return deviceDao.searchDevice(deviceSearchParameters);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	*/
}
