package gov.va.med.ccht.persistent.hibernate;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.persistent.VendorDAO;

@Repository
@Transactional
public class VendorDAOImpl implements VendorDAO{
	
	public VendorDAOImpl() {
	}
	
	public VendorDAOImpl(SessionFactory factory) {
        sessionFactory = factory;
	}
	
	@Autowired
	private SessionFactory sessionFactory;

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}
	
	@Override
	public List<Vendor> getActiveVendors() {

		final StringBuilder sql = new StringBuilder();
		sql.append("select * from Vendor ");
		sql.append("where vendor_number is not null ");
		sql.append("and date_inactive is null ");
		sql.append("and date_active is not null ");
		sql.append("order by vendor_name asc ");
		
		return getSession()
				.createNativeQuery(sql.toString(), Vendor.class)
				.getResultList();
		
	}
	
	@Override
	public List<Vendor> getAllVendors() {
		// Vendors that have a null vendor number or a null active date
		// should not be included.
		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * FROM vendor WHERE vendor_number is not null ");
		sql.append("AND date_active is not null ");
		sql.append("order by vendor_name asc");
		return getSession()
				.createNativeQuery(sql.toString(), Vendor.class)
				.getResultList();
	}

	@Override
	public Vendor getVendor(String name) {

		final String sql = "select * from Vendor where vendor_name = :name";
		return getSession()
				.createNativeQuery(sql, Vendor.class)
				.setParameter("name", name)
				.getSingleResult();

	}
	
	@Override
	public Vendor getVendorById(Long id) {
		final String sql = "select * from Vendor where vendor_id = :id";
		return getSession()
				.createNativeQuery(sql, Vendor.class)
				.setParameter("id", id)
				.getSingleResult();
	}

	@Override
	public void insertVendor(Vendor vendor) {
		getSession().save(vendor);
	}
	@Override
	public void deleteVendor(Vendor vendor) {
		getSession().delete(vendor);
	}

}
