package gov.va.med.ccht.persistent.hibernate;

import java.sql.Timestamp;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.persistent.TimestampDAO;

@Repository
@Transactional
public class TimestampDAOImpl implements TimestampDAO {

	@Autowired
	private SessionFactory sessionFactory;
	
	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}

	@Override
	public Timestamp getCurrentTimestampFromDatabase() {
		
		return (Timestamp) sessionFactory
			.getCurrentSession()
			.createNativeQuery("select getutcdate()")
			.uniqueResult();
		
	}
	
}
