/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.persistent.hibernate;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

import javax.transaction.Transactional;

import org.springframework.stereotype.Repository;

import gov.va.med.ccht.model.common.DIReportParameters;
import gov.va.med.ccht.model.report.ReportParameters;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.model.report.scheduled.DateRangeBoundary;
import gov.va.med.fw.util.DateUtils;

/**
 * 
 * 
 * IHTA ohrs_common Nov 4, 2010
 * 
 * @author DNS
 */
@Repository
@Transactional
public class StandardReportDataDAOImpl extends AbstractStandardReportDataDAOImpl {
	
	private static final long serialVersionUID = -5623959498516400752L;

	public static final long MILLISECONDS_DAY = 24 * 60 * 60 * 1000;

	private boolean postProcessRequired;
	private boolean paginated;
	private String queryName;
	
	
	public boolean isPostProcessRequired() {
		return postProcessRequired;
	}

	public void setPostProcessRequired(boolean postProcessRequired) {
		this.postProcessRequired = postProcessRequired;
	}

	public boolean isPaginated() {
		return paginated;
	}

	public void setPaginated(boolean paginated) {
		this.paginated = paginated;
	}

	public String getQueryName() {
		return queryName;
	}

	public void setQueryName(String queryName) {
		this.queryName = queryName;
	}

	@Override 
	protected Map<String, Object> getQueryParameters(ReportSetup setup) { 
		Map<String, Object> paramMap = super.getQueryParameters(setup);
		ReportParameters params = setup != null ? setup.getReportParameters() : null;
		if(params!=null) 
		{
		DIReportParameters diReportParams = (DIReportParameters) params;
		DateRangeBoundary scheduledReportFromDate = params.getScheduledReportFromDate();
		DateRangeBoundary scheduledReportToDate = params.getScheduledReportToDate();

		boolean isScheduledReport = scheduledReportFromDate != null && scheduledReportToDate != null;

		Date reportStartDate = diReportParams.getReportWeek() == null ? null : diReportParams.getReportWeek().getStartDate();
		Date reportEndDate = diReportParams.getReportWeek() == null ? null : diReportParams.getReportWeek().getEndDate();
	
		if (isScheduledReport) {
			//calculate the dates
		} else {
			//adjust the dates if needed or compute other required dates
		}
		
		if (diReportParams.getFromDate() != null) {
			paramMap.put("fromDate", diReportParams.getFromDate());
		}else {
			//default from date
			Calendar cal = Calendar.getInstance();
			cal.set(2000,0,1,0,0,0); //Olddest date for IHTA database
			paramMap.put("fromDate", cal.getTime());
		}
		if (diReportParams.getToDate() != null) {
			paramMap.put("toDate", diReportParams.getToDate());
		}else {			
			//default to date
			paramMap.put("toDate", DateUtils.getTomorrowDate());
		} 
		if (reportStartDate != null) {
			paramMap.put("reportStartDate", reportStartDate);
		}
		if (reportEndDate != null) {
			paramMap.put("reportEndDate", reportEndDate);
		}

		//Visn
		if (diReportParams.getVisn() != null) {
			paramMap.put("allVisn", "Visn");
			paramMap.put("visnId", diReportParams.getVisn().getId());
		}else {
			paramMap.put("allVisn", "allVisn");
			paramMap.put("visnId", new Long(0));
		}
		//Facilities
		if (diReportParams.getFacility() != null) {
			paramMap.put("allFacilities", "Facilitiy");
			paramMap.put("facilityId", diReportParams.getFacility().getId());
		}else {
			paramMap.put("allFacilities", "allFacilities");
			paramMap.put("facilityId", new Long(0));
		}

		}		
		// return parameter map
		return paramMap; 
	}

	// Returns the date in the server time zone as entered by the user
	protected Date getUserDate(Date userDate, TimeZone userTz) {
		
		if (userDate == null) {
			return null;
		}
		
		Calendar cal = Calendar.getInstance();
		
		cal.setTime(userDate);
		cal.setTimeZone(userTz);
		
		return cal.getTime();

	}

	protected Date getDefaultFromDate() {
		return DateUtils.createCalendar(1900, 1, 1).getTime();
	}

	protected Date addDay(Date userDate) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(userDate);
		cal.add(Calendar.DATE, 1);
		return cal.getTime();
	}
}
