package gov.va.med.ccht.persistent.hibernate;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.common.DeviceTrackerLog;
import gov.va.med.ccht.model.report.AggregateModality;
import gov.va.med.ccht.persistent.ReportsDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.ui.model.TermType;

@Repository
@Transactional
public class ReportsDAOImpl implements ReportsDAO {

	@Autowired
	private SessionFactory sessionFactory;
	
	public ReportsDAOImpl() {
	}

	public ReportsDAOImpl(SessionFactory factory) {
		sessionFactory = factory;
	}
		
	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}
	
	@Override
	public List<TermType> getModalityType(int type) throws DAOException {
		List<TermType> modalityTypes = new ArrayList<TermType>();
		String tableName = null;

		switch (type) {
		case 0:
			tableName = "ht.SURVEY_DVC_MODALITY_TYPE ";
			break;

		case 1:
			tableName = "ht.CENSUS_DVC_MODALITY_TYPE ";
			break;
		}

		StringBuilder sb = new StringBuilder();
		sb.append("SELECT NAME ");
		sb.append("FROM ");
		sb.append(tableName);
		sb.append("WHERE INACTIVE_DATE IS Null");

		final List<String> names = getSession().createNativeQuery(sb.toString(), String.class).getResultList();

		names.forEach(name -> {
			TermType termType = new TermType(name, name);
			modalityTypes.add(termType);
		});

		return modalityTypes;
	}
	
	@Override
	public void setVendorComplianceReportCompletion(List<DeviceTrackerLog> deviceTrackerLogs) {
		deviceTrackerLogs.forEach(dtl -> {
			dtl.setProcessed(true);
			getSession().save(dtl);
		});

	}
	
	@Override
	public List<AggregateModality> getAggregateModalities() {
		String sql = "SELECT * FROM Modality_Aggregate_Type order by sort_order asc";
		return getSession().createNativeQuery(sql, AggregateModality.class).getResultList();
	}
	
	@Override
	public AggregateModality getAggregateModalityByCode(String code) {
		String sql = "SELECT * FROM Modality_Aggregate_Type WHERE code = :code";
		return getSession()
				.createNativeQuery(sql, AggregateModality.class)
				.setParameter("code", code)
				.getSingleResult();
	}

}
