package gov.va.med.ccht.persistent.hibernate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.persistence.Query;
import javax.transaction.Transactional;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import gov.va.med.ccht.model.pssreport.DistributionOfSurveysReport;
import gov.va.med.ccht.persistent.PssDistributionReportDAO;
import gov.va.med.ccht.ui.model.PSSReportForm;

/**
 * 
 * @author DNS
 *
 */

@Repository
@Transactional
public class PssDistributionReportDAOImpl  implements PssDistributionReportDAO{

	private static final int ALL_SURVEYS = 1;
	private static final int PSS_V1 = 2;
	private static final int PSS_V2 = 3;
	
	public static final int NATIONAL_SELECTION = 1;
	public static final int VISN_SELECTION = 2;
	public static final int FACILITY_SELECTION = 3;
	
	private static final String DO_NOT_INCLUDE = "-2";
	private static final String ALL_MODALITIES = "-1";
	private static final String BROWSER = "11503";
	private static final String IVR = "11502";
	private static final String HOME_DEVICE = "11501";
	
	private static final String BROWSER_DATA = "Browser";
	private static final String IVR_DATA = "IVR";
	private static final String HOME_DEVICE_DATA = "Home Device";
	
	private static final String ALL_VISNS = "-1";
	private static final String ALL_FACILITIES = "-1";
	
	private static final int BREAKOUT_COL = 0;
	private static final int VENDOR_NAME = 1;
	private static final int NUM_OF_SURVEYS = 2;
	private static final int MODALITY = 3;
	
	private static final int NATIONAL = 1;
	private static final int VISN = 2;
	private static final int FACILITY = 3;
	
	@Autowired
	private SessionFactory sessionFactory;
	
	public PssDistributionReportDAOImpl() {
	}

	public PssDistributionReportDAOImpl(SessionFactory factory) {
		sessionFactory = factory;
	}

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}
	
	@Override
    public DistributionOfSurveysReport getNationalReport(PSSReportForm form)
    {
		StringBuilder sql = new StringBuilder();
        
		sql.append("SELECT 'na' AS [Breakout], ");
		sql.append("v.vendor_name, COUNT(*) AS [NumSurveys] ");

		if(form.getModalityName().equals(ALL_MODALITIES)) {
			sql.append(addModalityBreakout());
		}
		
		sql.append("FROM Surveyed_Activity AS sa ");
		sql.append("INNER JOIN Surveyed_Activity_Response AS sar ON sa.Surveyed_Activity_ID = sar.Surveyed_Activity_ID ");
		sql.append("INNER JOIN Vendor AS v ON sa.Vendor_ID = v.Vendor_ID ");
		sql.append("INNER JOIN Device ON sa.Device_ID = Device.Device_ID ");
		
		SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		sql.append("WHERE sar.completed_date >= '"  + df.format(form.getReportFromDate()) + " 12:00:00 AM' ");
		sql.append("AND sar.completed_date <= '" + df.format(form.getReportToDate()) + " 11:59:59 PM' ");
		
		sql.append("AND sar.survey_accepted_status = 1 ");
		sql.append(addReportVersion(form.getReportVersionButtonSelection()));
        sql.append(addModality((form.getModalityName())));
		sql.append("GROUP BY v.vendor_name ");

		if(form.getModalityName().equals(ALL_MODALITIES)) {
			sql.append(addModalityBreakout());
		}
		
		sql.append("ORDER BY v.vendor_name ASC");
		
		final Query query = getSession().createNativeQuery(sql.toString());

		return generateReport(query, NATIONAL_SELECTION, form); 
		
    }
	
	@Override
    public DistributionOfSurveysReport getVisnReport(PSSReportForm form)
    {
		StringBuilder sql = new StringBuilder();
        
		sql.append("SELECT sa.VISN_ID AS [Breakout], ");
		sql.append("v.vendor_name, COUNT(*) AS [NumSurveys] ");
		
		if(form.getModalityName().equals(ALL_MODALITIES)) {
			sql.append(addModalityBreakout());
		}
		
		sql.append("FROM Surveyed_Activity AS sa ");
		sql.append("INNER JOIN Surveyed_Activity_Response AS sar ON sa.Surveyed_Activity_ID = sar.Surveyed_Activity_ID ");
		sql.append("INNER JOIN Vendor AS v ON sa.Vendor_ID = v.Vendor_ID ");
		sql.append("INNER JOIN Device ON sa.Device_ID = Device.Device_ID ");
		
		SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		sql.append("WHERE sar.completed_date >= '"  + df.format(form.getReportFromDate()) + " 12:00:00 AM' ");
		sql.append("AND sar.completed_date <= '" + df.format(form.getReportToDate()) + " 11:59:59 PM' ");
		sql.append("AND sar.survey_accepted_status = 1 ");
		
		if(!form.getVisnId().equals(ALL_VISNS)) {
			
			sql.append("AND sa.VISN_ID = " + form.getVisnId());
		}
		
		sql.append(addReportVersion(form.getReportVersionButtonSelection()));
		sql.append(addModality((form.getModalityName())));
		sql.append("GROUP BY sa.VISN_ID, v.vendor_name ");
		
		if(form.getModalityName().equals(ALL_MODALITIES)) {
			sql.append(addModalityBreakout());
		}
		
		sql.append("ORDER BY sa.VISN_ID, v.vendor_name ASC");
		
		final Query query = getSession().createNativeQuery(sql.toString());
		
		return generateReport(query, VISN_SELECTION, form); 
    }
	
	@Override
    public DistributionOfSurveysReport getFacilityReport(PSSReportForm form)
    {
		StringBuilder sql = new StringBuilder();
        
		sql.append("SELECT f.facility_id + ' ' + f.facility_name AS [Breakout], v.vendor_name, COUNT(*) AS [NumSurveys] ");
		
		if(form.getModalityName().equals(ALL_MODALITIES)) {
			sql.append(addModalityBreakout());
		}
		
		sql.append("FROM Surveyed_Activity AS sa ");
		sql.append("INNER JOIN Surveyed_Activity_Response AS sar ON sa.Surveyed_Activity_ID = sar.Surveyed_Activity_ID ");
		sql.append("INNER JOIN Vendor AS v ON sa.Vendor_ID = v.Vendor_ID ");
		sql.append("INNER JOIN Device ON sa.Device_ID = Device.Device_ID ");
		sql.append("INNER JOIN Facilities as f ON f.ID = sa.facility_ID ");
		
		SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		sql.append("WHERE sar.completed_date >= '"  + df.format(form.getReportFromDate()) + " 12:00:00 AM' ");
		sql.append("AND sar.completed_date <= '" + df.format(form.getReportToDate()) + " 11:59:59 PM' ");
		sql.append("AND sar.survey_accepted_status = 1 ");
		
		if(!form.getFacilityId().equals(ALL_FACILITIES)) {
			sql.append("AND f.facility_id = '" + form.getFacilityId() + "' ");
		}
		
		sql.append(addReportVersion(form.getReportVersionButtonSelection()));
		sql.append(addModality((form.getModalityName())));
		sql.append("GROUP BY f.facility_id, f.facility_name, v.vendor_name ");
		
		if(form.getModalityName().equals(ALL_MODALITIES)) {
			sql.append(addModalityBreakout());
		}
		
		sql.append("ORDER BY f.facility_id, f.facility_name, v.vendor_name ASC");
		
		final Query query = getSession().createNativeQuery(sql.toString());
		
		return generateReport(query, FACILITY_SELECTION, form); 
    }

	private DistributionOfSurveysReport generateReport(Query reportQuery, int typeOfReport, PSSReportForm form) {
		
		List<Object[]> reportData = reportQuery.getResultList();
		
		DistributionOfSurveysReport report = new DistributionOfSurveysReport();
		String modality = form.getModalityName();
		
		if (reportData.isEmpty()) {
			return report;
		}
		if(!modality.equals(ALL_MODALITIES)){
			for(Object[] reportRow : reportData) {
				
				report.addRow(reportRow, typeOfReport, form);
			}
		} else {
			String vendor = "";
			String facility = "";
			String previousFacility = "";
			// get vendor name of first entry in data set.
			String previousVendor = (String) reportData.get(0)[VENDOR_NAME];
			if(typeOfReport == FACILITY) {
			previousFacility =  String.valueOf(reportData.get(0)[BREAKOUT_COL]);
			}
			String row[] = new String[6];
			row[2] = "0";
			row[3] = "0";
			row[4] = "0";
			row[5] = "0";
			ArrayList<String[]> reportBuilder = new ArrayList<String[]>();
			int totalNumSurveysPerVendor = 0;
			for(Object[] reportRow : reportData) {
				vendor = (String) reportRow[VENDOR_NAME];
				facility = String.valueOf(reportRow[BREAKOUT_COL]);
				if(!vendor.equals(previousVendor) && typeOfReport != FACILITY) { 
					reportBuilder.add(row);
					totalNumSurveysPerVendor = 0;
					row = new String[6];
					row[2] = "0";
					row[3] = "0";
					row[4] = "0";
					row[5] = "0";
				}
				else if((!vendor.equals(previousVendor) || !facility.equals(previousFacility)) && typeOfReport == FACILITY) {
					reportBuilder.add(row);
					totalNumSurveysPerVendor = 0;
					row = new String[6];
					row[2] = "0";
					row[3] = "0";
					row[4] = "0";
					row[5] = "0";
				}
					switch(typeOfReport){
						case NATIONAL:
							break;
						case VISN:
							row[0] = "VISN " + String.valueOf(reportRow[BREAKOUT_COL]);
							break;
						case FACILITY:
							row[0] = "Facility " + String.valueOf(reportRow[BREAKOUT_COL]);
							break;
					} // end switch
					
					row[1] = (String)reportRow[VENDOR_NAME];
					totalNumSurveysPerVendor += (int) reportRow[NUM_OF_SURVEYS];
					row[2] = Integer.toString(totalNumSurveysPerVendor);
					
					String modalityType = (String) reportRow[MODALITY];
					
					switch(modalityType) {
						// not all cases will be hit, so rows also set to zero above.
						case IVR_DATA:
							row[3] = Integer.toString((int)reportRow[NUM_OF_SURVEYS]);
							break;
						case BROWSER_DATA:
							row[4] = Integer.toString((int)reportRow[NUM_OF_SURVEYS]);
							break;
						case HOME_DEVICE_DATA:
							row[5] = Integer.toString((int)reportRow[NUM_OF_SURVEYS]);
							break;
					}
				
				previousVendor = vendor;
				previousFacility = facility;
			} // end for
			reportBuilder.add(row);
			report.setReport(reportBuilder);
			// once all rows are added, create totals row.
			report.createTotalsRow(6);
			return report;
		} // end else
		// once all rows are added, create totals row.
		report.createTotalsRow(3);
		
		return report;
	}
	
//	private void addRowAndReset() {
//		reportBuilder.add(row);
//		totalNumSurveysPerVendor = 0;
//		row = new String[6];
//		row[2] = "0";
//		row[3] = "0";
//		row[4] = "0";
//		row[5] = "0";
//	}
	
	private String addReportVersion(int reportSelection) {
		
		String sql = "";
		
		switch (reportSelection)
        {
            case ALL_SURVEYS:
                //sql set up to not include vr-12 data
            	sql = "AND sar.survey_id != 1 ";
                break;
            case PSS_V1:
            	sql = "AND sar.survey_id = 2 ";
                break;
            case PSS_V2:
            	sql = "AND sar.survey_id = 3 ";
                break;
            default:
            	sql = "AND sar.survey_id != 1 ";
                break;
        }
		return sql;
	}
	
	private String addModality(String selectedModality) {
		
		String sql = "";
		
		switch (selectedModality)
        {
	        case BROWSER:
	        	sql = "AND device_name = 'BROWSER' ";
	            break;
	        case IVR:
	        	sql = "AND device_name = 'IVR' ";
	            break;
	        case HOME_DEVICE:
	        	sql = "AND device_name NOT IN ('IVR', 'BROWSER') ";
	            break;
            case DO_NOT_INCLUDE:
                break;
            case ALL_MODALITIES:
            	sql = "AND device_name IS NOT NULL ";
                break;
        }
		return sql;
	}
	
	private String addModalityBreakout() {
		
		return ",CASE Device.device_name WHEN 'IVR' THEN Device.device_name " +
			   "WHEN 'BROWSER' THEN Device.device_name " +
			   "ELSE 'Home Device' END ";
	}
}
