package gov.va.med.ccht.persistent.hibernate;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.common.Device;
import gov.va.med.ccht.model.common.DeviceType;
import gov.va.med.ccht.persistent.DeviceDAO;
import gov.va.med.fw.persistent.DAOException;

@Repository
@Transactional
public class DeviceDAOImpl implements DeviceDAO {
	
	@Autowired
	private SessionFactory sessionFactory;

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}

	@Override
	public List<Device> getDevices() throws DAOException {
		final String sql = "select * from device where deviceName is not null and deviceName != '' order by deviceName asc";
		return getSession().createNativeQuery(sql, Device.class).getResultList();
	}

	@Override
	public Device getDevice(String name) throws DAOException {

		final String sql = "select * from Device where deviceName = :deviceName";
		return getSession()
				.createNativeQuery(sql, Device.class)
				.setParameter("deviceName", name)
				.getSingleResult();

	}

	@Override
	public DeviceType getDeviceType(String code) throws DAOException {

		final String sql = "select * from DeviceType where code = :code";
		return getSession()
				.createNativeQuery(sql, DeviceType.class)
				.setParameter("code", code)
				.getSingleResult();
		
	}
	/*
	 * TODO: THE FOLLOWING COMMENTED BLOCK COULD BE RE-IMPLEMENTED ONCE WE RE-INTRODUCE REPORTS
	@Override
	@SuppressWarnings("unchecked")
	public List<DeviceRequirement> getDeviceRequirements(SimpleFacility simpleFacility) throws DAOException {
		
		logger.error("$$$$$$ fix me");
		return null;
//		try {
//			Map<String, Object> params = new HashMap<String, Object>();
//			params.put("facilityId", simpleFacility.getId());	    
//			String query = "select dr from gov.va.med.ccht.model.common.DeviceRequirement dr where dr.facility.id = :facilityId";
//			
//			//get device requirements from shortage table
//			List<DeviceRequirement> deviceRequirements =  getJpaTemplate().findByNamedParams(query, params);
//			
//			//get device inventory from device details table		
//			Map<String,Object> parameters = new HashMap<String,Object>();
//			parameters.put("facilityId", simpleFacility.getId());
//			List<Object[]> data =  getJpaTemplate().findByNamedQueryAndNamedParams("facilityDeviceInventory", parameters);
//			
//			//merge
//			for (Object[] objs:data) {
//				
//				Boolean deviceNotFound = true;
//				for (DeviceRequirement dr:deviceRequirements) {
//					if (dr.getDeviceType().getCode().equals((String)objs[0])) {
//						dr.setDevicesOnHand((Integer) objs[1]);
//						deviceNotFound = false;
//						break;
//					}
//				}
//				
//				//device requirement not found add a new entry
//				if (deviceNotFound) {
//					DeviceRequirement newDevReq = new DeviceRequirement();
//					newDevReq.setFacility(simpleFacility);
//					DeviceType dt = getDeviceType((String)objs[0]);
//					newDevReq.setDeviceType(dt);
//					newDevReq.setDevicesOnHand((Integer) objs[1]);
//					newDevReq.setDevicesNeeded(0);
//					deviceRequirements.add(newDevReq);
//				}
//			}				
//			return deviceRequirements;
//		}catch (Exception e){
//			throw new DAOException(e.getMessage(),e);
//		}
	}
	

	@Override
	public DeviceRequirement getDeviceRequirement(int id) {
		
		final String sql = "select * from DeviceType where id = :id";
		return getSession()
				.createNativeQuery(sql, DeviceRequirement.class)
				.setParameter("id", id)
				.getSingleResult();
		
	}

	
	@Override
	public void updateDeviceDetail(DeviceDetail dd) {
		getSession().update(dd);
	}
	
	@Override
	public void updateDeviceRequirements(List<DeviceRequirement> deviceRequirements) {
		deviceRequirements.forEach(dr -> {
			getSession().update(dr);
		});
	}

	@Override
	public DeviceDetail getDeviceDetail(DeviceSearchParameters deviceSearchParameters) throws DAOException
	{

		final String sql = "select * from DeviceDetail where deviceType.code = :deviceType and serialNumber = :serialNumber";
		return getSession()
				.createNativeQuery(sql, DeviceDetail.class)
				.setParameter("deviceType", deviceSearchParameters.getDeviceType().getValue())
				.setParameter("serialNumber", deviceSearchParameters.getSerialNumber())
				.getSingleResult();

	}
	
	@Override
	public DeviceDetail findDeviceDetail(int id) {
		
		final String sql = "select * from Device_Detail where id = :id";
		return getSession()
				.createNativeQuery(sql, DeviceDetail.class)
				.setParameter("id", id)
				.getSingleResult();
		
	}
	

	@Override
	@SuppressWarnings("unchecked")
	public List<DeviceTrackerLog> getUnprocessedDeviceTrackerLogs() throws DAOException {

		String sql = "select * from DeviceTrackerLog where processed is null";

		return getSession()
				.createNativeQuery(sql, DeviceTrackerLog.class)
				.getResultList();
		
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<Object[]> searchDevice(DeviceSearchParameters deviceSearchParameters) throws DAOException {
		
		logger.error("$$$$$$ fix me");
		return null;
		
//		try {
//			String searchType = deviceSearchParameters.getSearchType().getValue();
//			QueryAndParams queryAndParams = null;
//			if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_SERIAL_NUMBER.equals(searchType)){
//				queryAndParams = buildQuerySearchBySerialNumber(deviceSearchParameters);			
//			}
//			else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_PATIENT.equals(searchType)){
//				queryAndParams = buildQuerySearchByPatient(deviceSearchParameters);
//			}
//			else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_ACTIVATION_DATE.equals(searchType)){
//				queryAndParams = buildQuerySearchByActivationDate(deviceSearchParameters);
//			}
//			else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_STATUS.equals(searchType)){
//				queryAndParams = buildQuerySearchByStatus(deviceSearchParameters);
//			}
//			else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_GENERIC.equals(searchType)){
//				queryAndParams = buildQuerySearchByGeneric(deviceSearchParameters);
//			}
//			else {
//				throw new DAOException("Invalid Device search type" + searchType);
//			}
//			List<Object[]> results = (List<Object[]>) executeSQLQuery(queryAndParams);
//			return results;
//			} catch (DataAccessException e) {
//				throw new DAOException(e.getMessage(), e);
//			}
	}
	*/

}
