/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.persistent;

import java.util.List;
import java.util.Map;

import org.springframework.security.core.userdetails.UserDetailsService;

import gov.va.med.ccht.model.SimpleUser;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserRole;
import gov.va.med.ccht.model.terminology.FederalHoliday;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.security.UserPrincipal;

/**
 * 
 * 
 * IHTA IHTA_common Jun 24, 2010
 * 
 * @author DNS
 */
public interface SecurityDAO extends UserDetailsService {
	
	public void persist(Role role);
	public void remove(Role role);
	public void persist(UserRole userRole);
	public void remove(UserRole userRole);
	
	public Object getByKey(EntityKey<?> entityKey);

	Map<String, UserPrincipal<?>> findUsersWithAnyRole(List<String> roles);
	/**
	 * Get user by name
	 * 
	 * @param userId
	 * @return
	 */
	public User getUserByName(String userId);
	
	public Role getRoleById(long id);

	public List<User> getSubmittedRegistrations(Integer visnId, Integer facilityId);

	/**
	 * Create user in the IHTA database
	 * 
	 * @param user
	 * @throws DAOException
	 */
	public void createUser(User user) throws DAOException;

	/**
	 * Update user in the IHTA database
	 * 
	 * @param user
	 * @throws DAOException
	 */
	public void updateUser(User user);

	/**
	 * Update role in the IHTA database
	 * 
	 * @param user
	 * @throws DAOException
	 */
	public void updateRole(Role role) throws DAOException;

	/**
	 * Find all roles
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<Role> findAllRoles() throws DAOException;
	
	/**
	 * Find all permissions
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<Permission> findAllPermissions() throws DAOException;

	/**
	 * Get Role by name
	 * 
	 * @param roleName
	 * @return the specified Role, or null if not found
	 */
	public Role getRoleByName(String roleName);
	public List<SimpleRole> findAllSimpleRoles() throws DAOException;
	public List<SimpleRole> findAllDMPRoles() throws DAOException;
	public List<User> getSubmittedRegistrationsForDmp(Integer visnId, Integer facilityId) throws DAOException;
	public List<User> getNewRegistrations(Integer visnId, Integer facilityId);
	public SimpleRole getSimpleRoleByName(String roleName) throws DAOException;

	/**
	 * Get available role names for assignment
	 * 
	 * @return
	 * @throws DAOException
	 */
//	public List<String> getAvailableRoleNames(Application application) throws DAOException;

	/**
	 * Get assigned permissions for a given role
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<String> getRolePermissionNames(String roleName) throws DAOException;
	
	public void deleteRole(Role role);
	public void deleteUserRole(UserRole userRole);

	public UserPrincipal getAuditUser(String userName) throws DAOException;
	public List<SimpleRole> getRolesByUserName(String userName);
	
	public List<FederalHoliday> findHolidays(int year) throws DAOException;
	public List<String> getUserIds() throws DAOException;
	public List<SimpleUser> findAppUsers(SearchCriteria searchCriteria) throws DAOException;
	public void deleteEntity(Object obj) throws DAOException;
	public void flush();
	public void deleteRolePermissionsFromRole(Role role);
	
}
