package gov.va.med.ccht.persistent;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRAttachment;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.model.qir.QIRSearchResult;
import gov.va.med.ccht.model.qir.QIRStatusType;
import gov.va.med.fw.persistent.DAOException;

public interface QIRDAO  {

	public QIR saveQIR(QIR qir);
	public List<String> getVendorResponseDueQIRIds();
	public Date getVendorResponseDueDate(long qirId);
	public List<QIR> findByIds(Collection<Long> ids);
	public QIR findById(Long id);
	public List<QIRStatusType> findAllQIRStatusTypes();
	public QIRStatusType findQIRStatusTypeByName(String name);
	public QIRStatusType findQIRStatusType(String code);

	public List<QIRSearchResult> searchQIR(QIRSearchParameters qirSearchParameters);
	
	public QIRAttachment findAttachmentById(Long attachmentId);
	public void updateAttachment(QIRAttachment attachment);
	public void deleteAttachment(Long attachmentId);

	public void insertQIRStatusType(QIRStatusType type);
	public void deleteQIRStatusType(QIRStatusType type);
	public void deleteQIR(QIR qir);
	
}
