package gov.va.med.ccht.persistent;

import java.util.List;

import gov.va.med.ccht.model.common.Facility;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.fw.persistent.DAOException;

public interface FacilityDAO {
	
	public List<Facility> getFacilities();

	public List<Facility> getFacilities(String visnName);
	
	public Facility getFacility(String stationNumber) throws DAOException;
	
	public Facility getFacilityById(Long id) throws DAOException;

	public SimpleFacility getSimpleFacility(String stationNumber);

	public List<SimpleFacility> getSortedSimpleFacilities();

	public List<SimpleFacility> getSimpleFacilities();

	public List<SimpleFacility> getSimpleFacilities(SimpleVisn visn);
	
	public void insertFacility(Facility facility);
	public void deleteFacility(Facility facility);

	List<Facility> getFacilitiesAscById();

}
