package gov.va.med.ccht.persistent;

import java.util.List;

import gov.va.med.ccht.model.common.Device;
import gov.va.med.ccht.model.common.DeviceType;
import gov.va.med.fw.persistent.DAOException;

public interface DeviceDAO {
	
	public List<Device> getDevices() throws DAOException;
	
	public Device getDevice(String name) throws DAOException;

	public DeviceType getDeviceType(String code) throws DAOException;

	/*
	 * TODO: THE FOLLOWING COMMENTED BLOCK COULD BE RE-IMPLEMENTED ONCE WE RE-INTRODUCE REPORTS
	 */
//	public List<DeviceRequirement> getDeviceRequirements(SimpleFacility simpleFacility) throws DAOException;
//
//	public DeviceRequirement getDeviceRequirement(int id);
//	
//	public void updateDeviceDetail(DeviceDetail dd);
//	
//	public void updateDeviceRequirements(List<DeviceRequirement> deviceRequirements);
//
//	public DeviceDetail getDeviceDetail(DeviceSearchParameters deviceSearchParameters) throws DAOException;
//	
//	public DeviceDetail findDeviceDetail(int id);
//
//	public List<DeviceTrackerLog> getUnprocessedDeviceTrackerLogs() throws DAOException;
//	
//	public List<Object[]> searchDevice(DeviceSearchParameters deviceSearchParameters) throws DAOException;

}
