package gov.va.med.ccht.persistent;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.ccht.model.car.CensusActivityVisnRecord;
import gov.va.med.ccht.model.report.AggregateModality;
import gov.va.med.ccht.ui.model.CensusActivityReportForm;
import gov.va.med.fw.persistent.DAOException;


public interface CensusActivityReportDAO 
{
	public CensusActivityRecord getAllVendorsReportStatus() throws DAOException;
		
	// New report methods.
	public List<CensusActivityRecord> getNationalReport(CensusActivityReportForm form) throws DAOException;
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(CensusActivityReportForm form)throws DAOException, ParseException;
	public List<CensusActivityRecord> getNationalReportByVendor(CensusActivityReportForm form)throws DAOException, ParseException;
	
	public List<CensusActivityRecord> getNationalReportByModality(CensusActivityReportForm form) throws DAOException;
	public List<CensusActivitySubTotalRecord> getSubtotaledNationalReportByModality(CensusActivityReportForm form)throws DAOException;
	public List<CensusActivityRecord> getNationalReportByModalityAndVendor(CensusActivityReportForm form) throws DAOException;
	public List<CensusActivityVisnRecord> getVisnReport(CensusActivityReportForm form,  List<AggregateModality> modalities)throws DAOException;
	public List<CensusActivityVisnRecord> getVisnDrilldownData(CensusActivityReportForm form, List<AggregateModality> modalities) throws DAOException;
	public List<CensusActivityVisnRecord> getSubtotaledVisnReport(CensusActivityReportForm form,  List<AggregateModality> modalities) throws DAOException;
	public List<CensusActivityVisnRecord> getSubtotaledFacilityReport(CensusActivityReportForm form,  List<AggregateModality> modalities) throws DAOException;
	public Date getMinStartDate() throws DAOException;
}
