package gov.va.med.ccht.model.terminology;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import gov.va.med.fw.model.lookup.AbstractLookup;

//@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
@Entity
@Table(schema="ht", name="HT_USER_GROUP")
public class UserGroup extends AbstractLookup {

	private static final long serialVersionUID = -8683538894287860990L;

	public static final String VA_USER = "1";
    public static final String VETERAN = "2";
    public static final String VENDOR = "3";
    
	private Long id;
	
	@Id
	@Column(name="ID")
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	public Long getId() {
		return this.id;
	}

	public void setId(Long identifier) {
		this.id = identifier;
	}
    
    public String toString() {
    	return getName();
    }
   	
}