/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.model.terminology;

import java.util.HashSet;
import java.util.Set;

import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.security.Permission;

@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY)
public class StandardReport extends AbstractLookup {

	private static final long serialVersionUID = -5259514417145116449L;

	public static final String DETAILED_PREFIX = "Detailed";
	private static final String SUMMARY_PREFIX = "Summary";

	private ReportType reportType = null;
	private Set<ReportPermission> internalPermisions = null;

	public ReportType getReportType() {
		return reportType;
	}

	public void setReportType(ReportType reportType) {
		this.reportType = reportType;
	}

	public Set<Permission> getPermissions() {
		// loop through and return the Permission objects
		Set<Permission> permisions = new HashSet<Permission>();
		for (ReportPermission rp : getInternalPermisions()) {
			permisions.add(rp.getPermission());
		}
		return permisions;
	}

	public String getDetailedReportPermission() {
		for (ReportPermission rp : getInternalPermisions()) {
			String name = rp.getPermission().getName();
			if (name.startsWith(DETAILED_PREFIX))
				return name;
		}
		return null;
	}

	public String getSummaryReportPermission() {
		for (ReportPermission rp : getInternalPermisions()) {
			String name = rp.getPermission().getName();
			if (name.startsWith(SUMMARY_PREFIX))
				return name;
		}
		return null;
	}

	private Set<ReportPermission> getInternalPermisions() {
		if (internalPermisions == null) {
			internalPermisions = new HashSet<ReportPermission>();
		}
		return internalPermisions;
	}
}
