package gov.va.med.ccht.model.terminology;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import gov.va.med.fw.model.lookup.AbstractLookup;

//@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
@Entity
@Table(schema="HT", name="REGISTRATION_STATUS")
public class RegistrationStatus extends AbstractLookup {

	private static final long serialVersionUID = 1L;
	public static final String SUBMITTED = "1";
	public static final String APPROVED = "2";
	public static final String REJECTED = "3";
	public static final String UNDER_REVIEW = "4";
	public static final String OTHER = "5";
	
	private Long id;
	
	@Id
	@Column(name="ID")
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public String toString() {
		return getName();
	}
}