package gov.va.med.ccht.model.terminology;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.AbstractLookup;

//@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
@Entity
@Table(schema="HT", name="HT_JOB_DESCRIPTION")
public class RegistrationReason extends AbstractLookup {
	private static final long serialVersionUID = -8417669706718648337L;
	
	private Short inactiveFlag = 0;
	
	private Long id;
	
	@Id
	@Column(name="ID")
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	public Long getId() {
		return this.id;
	}

	public void setId(Long identifier) {
		this.id = identifier;
	}

	@Column(name = "INACTIVE_FLAG")
	public Short getInactiveFlag() {
		return inactiveFlag;
	}

	public void setInactiveFlag(Short inactiveFlag) {
		this.inactiveFlag = inactiveFlag;
	}
	
	@Transient
	public Boolean isInactive() {
		return inactiveFlag == 1;
	}
	
	public String toString() {
		return getName();
	}
}