/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 24, 2010
 *
 */
package gov.va.med.ccht.model.terminology;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY)
public class DayOfQuarter extends AbstractLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5174533696576472032L;
	public static final Code CODE_FIRST = new Code("1");

	public static final Code CODE_LAST = new Code("2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3689594810683316880L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
}
