package gov.va.med.ccht.model.satisfactionsurvey;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.ccht.ui.model.PSSReportForm;
import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

import edu.emory.mathcs.backport.java.util.Collections;

public class SatisfactionSurveyQuestionResult implements Serializable {
	private static final long serialVersionUID = 8608236239139997875L;

	private static final CharSequence TOTAL = "Total";

	private Integer questionNumber;
	// limited to upper case, lower case, numbers, period, colon, comma, open/close paren, and question mark.
	private String questionText;
	
	private String formattedQuestionText;
	private String modality;
	private String ALL_MODALITIES = "-1";
	private List<SatisfactionSurveyQuestion> results;
	private Map<Integer, List<SatisfactionSurveyQuestion>> resultsKeyedByMonth;

	public void setModality(String modality) {
		this.modality = modality;
	}

	public Integer getQuestionNumber() {
		return questionNumber;
	}

	public void setQuestionNumber(Integer questionNumber) {
		this.questionNumber = questionNumber;
	}

	public String getQuestionText() {
		return questionNumber + ") " + questionText;
	}

	public void setQuestionText(String questionText) {
		this.questionText = ESAPIValidator.validateStringInput(questionText, ESAPIValidationType.QuestionShortText_WhiteList);
	}

	public String getFormattedQuestionText() {
		return formattedQuestionText;
	}

	public void setFormattedQuestionText(String formattedQuestionText) {
		this.formattedQuestionText = formattedQuestionText;
	}

	public void setFormattedQuestionText() {
		this.formattedQuestionText = questionNumber + ") " + questionText;
	}

	public List<SatisfactionSurveyQuestion> getResults() {
		if (results == null) {
			results = new ArrayList<SatisfactionSurveyQuestion>();
		}
		if (results.size() > 0) {
			return results;
		}
		for (Integer key : resultsKeyedByMonth.keySet()) {
			List<SatisfactionSurveyQuestion> values = resultsKeyedByMonth.get(key);
			SatisfactionSurveyQuestion totals = new SatisfactionSurveyQuestion();

			if (modality.equalsIgnoreCase("All")) {
				Double averageAnswer = 0d;
				int div = 0;
				for (SatisfactionSurveyQuestion temp : values) {
					totals.setMonthAsInt(temp.getMonthAsInt());
					totals.setQuestionNumber(temp.getQuestionNumber());
					totals.setAnswerCount(temp.getAnswerCount());
					totals.setModality(temp.getModality());
					totals.setMonthAsString(temp.getMonthAsString());
					totals.setQuestionText(temp.getQuestionText());
					totals.setYear(temp.getYear());
					totals.setTheDate(temp.getTheDate());
					averageAnswer += temp.getAvgAnswer();

					div += 1;
				}
				totals.setAvgAnswer((averageAnswer / div));
				totals.setHeaderString(true);

				values.add(totals);
			}

			results.addAll(values);
		}

		Collections.sort(results, new SatisfactionSurveyQuestionDateComparator());
		return results;
	}

	public void setResults(List<SatisfactionSurveyQuestion> results) {
		this.results = results;
	}

	public void addToResultsList(SatisfactionSurveyQuestion result) {
		if (results == null) {
			results = new ArrayList<SatisfactionSurveyQuestion>();
		}

		results.add(result);
	}

	public void addToResultsKeyedByMonthMap(SatisfactionSurveyQuestion result) {
		Integer key = result.getMonthAsInt();

		if (resultsKeyedByMonth == null) {
			resultsKeyedByMonth = new HashMap<Integer, List<SatisfactionSurveyQuestion>>();
		}

		if (resultsKeyedByMonth.containsKey(key)) {
			List<SatisfactionSurveyQuestion> statsForMonth = resultsKeyedByMonth.remove(key);
			statsForMonth.add(result);
			resultsKeyedByMonth.put(key, statsForMonth);
		} else {
			List<SatisfactionSurveyQuestion> statsForMonth = new ArrayList<SatisfactionSurveyQuestion>();
			statsForMonth.add(result);
			resultsKeyedByMonth.put(key, statsForMonth);
		}
	}
	
	public int getAmountOfSurveysForQuestion(PSSReportForm form) {
		int sum = 0;
		if(!form.getModalityName().equalsIgnoreCase(ALL_MODALITIES)) {
			for(SatisfactionSurveyQuestion question : getResults()) {
				sum += question.getAnswerCount();
			}
			return sum;
		}
		List<SatisfactionSurveyQuestion> results = getResults();
		for(SatisfactionSurveyQuestion result : results) {
			if(result.getModality().contains(TOTAL)) {
				sum += result.getAnswerCount();
			}
		}
		return sum;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("SatisfactionSurveyQuestionResult [\nquestionNumber=");
		builder.append(questionNumber);
		builder.append("\n questionText=");
		builder.append(questionText);
		// builder.append("\n results=");
		// builder.append(results);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public boolean equals(Object obj) {
		return this.questionNumber.equals(((SatisfactionSurveyQuestionResult) obj).questionNumber);
	}

	@Override
	public int hashCode() {
		// TODO Auto-generated method stub
		return super.hashCode();
	}
}
