package gov.va.med.ccht.model.satisfactionsurvey;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class SatisfactionSurveyQuestion implements Serializable
{

	private static final long serialVersionUID = 594035784044523111L;

	private Integer questionNumber;
	private String questionText;
	private String modality;
	private Double avgAnswer;
	private Integer monthAsInt;
	private String monthAsString;
	private Integer year;
	private Integer answerCount;
	private String headerString;
	private Date theDate;
	
	public void setTheDate()
	{
		GregorianCalendar cal = new GregorianCalendar();
		theDate = cal.getTime();
	}
	
	public void setTheDate(Date theDate)
	{
		
		this.theDate = theDate;
	}
	
	public Date getTheDate()
	{
		
		if(theDate == null)
		{
			setTheDate();
		}
		
		return theDate;
	}
	
	public void setHeaderString(boolean isTotalHeader)
	{
		StringBuilder sb = new StringBuilder();
	
		sb.append(monthAsString);
		sb.append(" ");
		sb.append(year);
		sb.append(" ");

		
		if(isTotalHeader)
		{
			sb.append("Total");
		}
		else
		{
			sb.append(modality);
			sb.append(" ");
			sb.append("Patient Satisfaction Index");
		}
		
		
		this.headerString = sb.toString();
	}
	
	public void setHeaderString(String headerString)
	{
		this.headerString = headerString;
	}
	
	public String getHeaderString()
	{
		return headerString;
	}

	public Integer getQuestionNumber()
	{
		return questionNumber;
	}

	public void setQuestionNumber(Integer questionNumber)
	{
		this.questionNumber = questionNumber;
	}

	public String getQuestionText()
	{
		return  questionNumber + ". " + questionText;
	}

	public void setQuestionText(String questionText)
	{
		this.questionText = questionText;
	}

	public String getModality()
	{
		return modality;
	}

	public void setModality(String modality)
	{
		this.modality = modality;
	}

	public Double getAvgAnswer()
	{
		return avgAnswer;
	}

	public void setAvgAnswer(Double avgAnswer)
	{
		this.avgAnswer = avgAnswer;
	}

	public Integer getMonthAsInt()
	{
		return monthAsInt;
	}

	public void setMonthAsInt(Integer monthAsInt)
	{
		this.monthAsInt = monthAsInt;
	}
	

	public String getMonthAsString()
	{
		return monthAsString;
	}
	
	public void setMonthAsString(String monthAsString)
	{		
		this.monthAsString = monthAsString;		
	}

	public void setMonthAsString()
	{
		Calendar cal = new GregorianCalendar(year, (monthAsInt - 1), 1);
		this.monthAsString = cal.getDisplayName(Calendar.MONTH, Calendar.LONG, Locale.getDefault());
	}
	
	public Integer getYear()
	{
		return year;
	}

	public void setYear(Integer year)
	{
		this.year = year;
	}

	public Integer getAnswerCount()
	{
		return answerCount;
	}

	public void setAnswerCount(Integer answerCount)
	{
		this.answerCount = answerCount;
	}

	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		builder.append("SatisfactionSurveyQuestion [answerCount=");
		builder.append(answerCount);
		builder.append(", avgAnswer=");
		builder.append(avgAnswer);
		builder.append(", modality=");
		builder.append(modality);
		builder.append(", monthAsInt=");
		builder.append(monthAsInt);
		builder.append(", questionNumber=");
		builder.append(questionNumber);
		builder.append(", questionText=");
		builder.append(questionText);
		builder.append(", year=");
		builder.append(year);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((answerCount == null) ? 0 : answerCount.hashCode());
		result = prime * result
				+ ((avgAnswer == null) ? 0 : avgAnswer.hashCode());
		result = prime * result
				+ ((headerString == null) ? 0 : headerString.hashCode());
		result = prime * result
				+ ((modality == null) ? 0 : modality.hashCode());
		result = prime * result
				+ ((monthAsInt == null) ? 0 : monthAsInt.hashCode());
		result = prime * result
				+ ((monthAsString == null) ? 0 : monthAsString.hashCode());
		result = prime * result
				+ ((questionNumber == null) ? 0 : questionNumber.hashCode());
		result = prime * result
				+ ((questionText == null) ? 0 : questionText.hashCode());
		result = prime * result + ((theDate == null) ? 0 : theDate.hashCode());
		result = prime * result + ((year == null) ? 0 : year.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SatisfactionSurveyQuestion other = (SatisfactionSurveyQuestion) obj;
		if (answerCount == null) {
			if (other.answerCount != null)
				return false;
		} else if (!answerCount.equals(other.answerCount))
			return false;
		if (avgAnswer == null) {
			if (other.avgAnswer != null)
				return false;
		} else if (!avgAnswer.equals(other.avgAnswer))
			return false;
		if (headerString == null) {
			if (other.headerString != null)
				return false;
		} else if (!headerString.equals(other.headerString))
			return false;
		if (modality == null) {
			if (other.modality != null)
				return false;
		} else if (!modality.equals(other.modality))
			return false;
		if (monthAsInt == null) {
			if (other.monthAsInt != null)
				return false;
		} else if (!monthAsInt.equals(other.monthAsInt))
			return false;
		if (monthAsString == null) {
			if (other.monthAsString != null)
				return false;
		} else if (!monthAsString.equals(other.monthAsString))
			return false;
		if (questionNumber == null) {
			if (other.questionNumber != null)
				return false;
		} else if (!questionNumber.equals(other.questionNumber))
			return false;
		if (questionText == null) {
			if (other.questionText != null)
				return false;
		} else if (!questionText.equals(other.questionText))
			return false;
		if (theDate == null) {
			if (other.theDate != null)
				return false;
		} else if (!theDate.equals(other.theDate))
			return false;
		if (year == null) {
			if (other.year != null)
				return false;
		} else if (!year.equals(other.year))
			return false;
		return true;
	}
}
