package gov.va.med.ccht.model.responserate;

public class ResponseRateRecord {

	private Integer id;
	private String stationNumber;
	private String vendorName;
	private int responseCode;
	private int patientCount;
	private int maxDataAge;

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String dummy) {
		this.stationNumber = dummy;
	}

	public String getVendorName() {
		return vendorName;
	}

	public void setVendorName(String vendorName) {
		this.vendorName = vendorName;
	}

	public int getResponseCode() {
		return responseCode;
	}

	public void setResponseCode(int responseCode) {
		this.responseCode = responseCode;
	}

	public int getPatientCount() {
		return patientCount;
	}

	public void setPatientCount(int patientCount) {
		this.patientCount = patientCount;
	}

	public int getMaxDataAge() {
		return maxDataAge;
	}

	public void setMaxDataAge(int maxDataAge) {
		this.maxDataAge = maxDataAge;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((stationNumber == null) ? 0 : stationNumber.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + maxDataAge;
		result = prime * result + patientCount;
		result = prime * result + responseCode;
		result = prime * result + ((vendorName == null) ? 0 : vendorName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ResponseRateRecord other = (ResponseRateRecord) obj;
		if (stationNumber == null) {
			if (other.stationNumber != null)
				return false;
		} else if (!stationNumber.equals(other.stationNumber))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (maxDataAge != other.maxDataAge)
			return false;
		if (patientCount != other.patientCount)
			return false;
		if (responseCode != other.responseCode)
			return false;
		if (vendorName == null) {
			if (other.vendorName != null)
				return false;
		} else if (!vendorName.equals(other.vendorName))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "ResponseRateRow [stationNumber=" + stationNumber + ", id=" + id + ", maxDataAge=" + maxDataAge + ", patientCount="
				+ patientCount + ", responseCode=" + responseCode + ", vendorName=" + vendorName + "]";
	}

}
