package gov.va.med.ccht.model.report.scheduled;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * A class that collects the various parameters for all possible
 * DateRangeBoundaryTypes.
 * 
 * @author DNS
 * 
 */
public class DateRangeBoundary {

	// ------------------------------- Fields

	private DateRangeBoundaryType type;

	/* Fields used by DateRangeBoundaryType.SPECIFIC_FIXED_DAY */
	private Date specificFixedDate;

	/* Fields used by DateRangeBoundaryType.EXACT_UNITS_PRIOR_TO_CURRENT_DAY */
	private Integer numUnitsPriorToCurrentDay;
	private SimpleTimeUnitType unitPriorToCurrentDay;

	/*
	 * Fields used by
	 * DateRangeBoundaryType.FIXED_DAY_OF_PREVIOUS_OR_CURRENT_UNIT
	 */
	private FixedDateType fixedDateType;
	private Boolean usePreviousDatePeriod;
	private MultiDayTimeUnitType multiDayTimeUnitType;

	// ------------------------------- Constructors

	/**
	 * Default constructor that does nothing.
	 */
	public DateRangeBoundary() {
	}

	/**
	 * Constructs a new instance of a DateRangeBoundary given the serialized
	 * version produced by the toString() method
	 * 
	 * @param serializedVersion
	 *            The String version as produced by the toString() method
	 */
	public DateRangeBoundary(String serializedVersion) {
		String[] tokens = serializedVersion.split(";");
		Map<String, String> tokenMap = new HashMap<String, String>();

		for (String token : tokens) {
			String[] keyAndValue = token.split(":");
			tokenMap.put(keyAndValue[0], keyAndValue.length > 1 ? keyAndValue[1] : null);
		}

		String s = tokenMap.get("type");
		type = (s == null) ? null : DateRangeBoundaryType.valueOf(s);

		s = tokenMap.get("specificFixedDate");
		specificFixedDate = (s == null) ? null : new Date(Long.valueOf(s));

		s = tokenMap.get("numUnitsPriorToCurrentDay");
		numUnitsPriorToCurrentDay = (s == null) ? null : new Integer(s);

		s = tokenMap.get("unitPriorToCurrentDay");
		unitPriorToCurrentDay = (s == null) ? null : SimpleTimeUnitType.valueOf(s);

		s = tokenMap.get("fixedDateType");
		fixedDateType = (s == null) ? null : FixedDateType.valueOf(s);

		s = tokenMap.get("usePreviousDatePeriod");
		usePreviousDatePeriod = (s == null) ? null : new Boolean(s);

		s = tokenMap.get("multiDayTimeUnitType");
		multiDayTimeUnitType = (s == null) ? null : MultiDayTimeUnitType.valueOf(s);
	}

	// ------------------------------- Business Methods

	/**
	 * Returns a user-friendly description of this DateRangeBoundary (e.g.
	 * "The current day")
	 */
	public String getFriendlyDescription() {
		return type == null ? null : type.getFriendlyDescription(this);
	}

	/**
	 * Calculates a new date relative to the specified startDate based on the
	 * criteria (fields) of this DateRangeBoundary.
	 * 
	 * @param startDate
	 *            The date relative to which we're running the calculation
	 * @return The new date
	 */
	public Date calculateDate(Date startDate) {
		return type.calculateDate(startDate, this);
	}

	/**
	 * Returns this DateRangeBoundary in a String (serialized) form, with fields
	 * separated by a semicolon; this can later be sent to the String
	 * constructor to fully restore the object.
	 */
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("type:");
		if (type != null)
			sb.append(type);

		sb.append(";specificFixedDate:");
		if (specificFixedDate != null)
			sb.append(specificFixedDate.getTime());

		sb.append(";numUnitsPriorToCurrentDay:");
		if (numUnitsPriorToCurrentDay != null)
			sb.append(numUnitsPriorToCurrentDay);

		sb.append(";unitPriorToCurrentDay:");
		if (unitPriorToCurrentDay != null)
			sb.append(unitPriorToCurrentDay);

		sb.append(";fixedDateType:");
		if (fixedDateType != null)
			sb.append(fixedDateType);

		sb.append(";usePreviousDatePeriod:");
		if (usePreviousDatePeriod != null)
			sb.append(usePreviousDatePeriod);

		sb.append(";multiDayTimeUnitType:");
		if (multiDayTimeUnitType != null)
			sb.append(multiDayTimeUnitType);

		return sb.toString();
	}

	// ------------------------------- Accessor Methods

	public DateRangeBoundaryType getType() {
		return type;
	}

	public void setType(DateRangeBoundaryType type) {
		this.type = type;
	}

	public Date getSpecificFixedDate() {
		return specificFixedDate;
	}

	public void setSpecificFixedDate(Date specificFixedDate) {
		this.specificFixedDate = specificFixedDate;
	}

	public Integer getNumUnitsPriorToCurrentDay() {
		return numUnitsPriorToCurrentDay;
	}

	public void setNumUnitsPriorToCurrentDay(Integer numUnitsPriorToCurrentDay) {
		this.numUnitsPriorToCurrentDay = numUnitsPriorToCurrentDay;
	}

	public SimpleTimeUnitType getUnitPriorToCurrentDay() {
		return unitPriorToCurrentDay;
	}

	public void setUnitPriorToCurrentDay(SimpleTimeUnitType unitPriorToCurrentDay) {
		this.unitPriorToCurrentDay = unitPriorToCurrentDay;
	}

	public FixedDateType getFixedDateType() {
		return fixedDateType;
	}

	public void setFixedDateType(FixedDateType fixedDateType) {
		this.fixedDateType = fixedDateType;
	}

	public Boolean getUsePreviousDatePeriod() {
		return usePreviousDatePeriod;
	}

	public void setUsePreviousDatePeriod(Boolean usePreviousDatePeriod) {
		this.usePreviousDatePeriod = usePreviousDatePeriod;
	}

	public MultiDayTimeUnitType getMultiDayTimeUnitType() {
		return multiDayTimeUnitType;
	}

	public void setMultiDayTimeUnitType(MultiDayTimeUnitType multiDayTimeUnitType) {
		this.multiDayTimeUnitType = multiDayTimeUnitType;
	}

}
