/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.model.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

import javax.validation.Valid;
import javax.validation.constraints.Past;

import org.apache.commons.lang3.builder.ToStringBuilder;

import gov.va.med.ccht.model.report.scheduled.DateRangeBoundary;
import gov.va.med.ccht.model.terminology.ReportFormat;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;

/**
 * IHTA IHTA_common Aug 8, 2010
 * 
 * @author DNS
 */
public class ReportParameters extends AbstractKeyedEntity<ReportParameters> {
	private static final long serialVersionUID = -12862804518559964L;

	// ------------------------------------------- Fields

	@Valid
	private TimeZone userTimeZone;
	@Valid
	private ReportSetup reportSetup;
	@Valid
	private ReportFormat reportFormat;
	
	private String reportName;
	
	// --- Date Fields (null if scheduled report)
	@Past
	private Date fromDate;
	private Date toDate;
	private Date asOfDate;

	// --- Scheduled Report Fields

	private DateRangeBoundary scheduledReportFromDate;
	private DateRangeBoundary scheduledReportToDate;
	private Integer daysToKeepCompletedReports;

	// ------------------------------------------- Business Methods

	/**
	 * The values in this map are sent to the Jasper reports code used to
	 * populate the report; they are more or less reference data used in the
	 * reports. CPB
	 */
	public Map<String, Object> getParameterMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		// common parameters
		SimpleDateFormat sdf = new SimpleDateFormat(DateUtils.MMDDYYYY);
		if (userTimeZone != null) {
			sdf.setTimeZone(userTimeZone);
			// map.put("userTimeZone", userTimeZone.getID());
		}
		// put the specified dates

		boolean isScheduledReport = scheduledReportFromDate != null
				&& scheduledReportToDate != null;
		if (isScheduledReport) {
			Date now = new Date();
			map.put("fromDateStr", sdf.format(scheduledReportFromDate.calculateDate(now)));
			String toDateStr = sdf.format(scheduledReportToDate.calculateDate(now));
			map.put("toDateStr", toDateStr);
			map.put("asOfDateStr", toDateStr);
		} else {
			if (fromDate != null)
				map.put("fromDateStr", sdf.format(fromDate));
			if (toDate != null)
				map.put("toDateStr", sdf.format(toDate));
			if (asOfDate != null)
				map.put("asOfDateStr", sdf.format(asOfDate));
		}

		return map;
	}

	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub
	}

	public boolean isDetailedReport() {
		// defaults to Detailed report
		return reportFormat == null ? true : ReportFormat.DETAIL.equals(
				reportFormat.getCode());
	}

	// ------------------------------------------- Accessor Methods

	public ReportSetup getReportSetup() {
		return this.reportSetup;
	}

	public void setReportSetup(ReportSetup reportSetup) {
		this.reportSetup = reportSetup;
	}

	public Date getFromDate() {
		return this.fromDate;
	}

	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}

	public Date getToDate() {
		return this.toDate;
	}

	public void setToDate(Date toDate) {
		this.toDate = toDate;
	}

	public Date getAsOfDate() {
		return asOfDate;
	}

	public void setAsOfDate(Date asOfDate) {
		this.asOfDate = asOfDate;
	}

	public ReportFormat getReportFormat() {
		return reportFormat;
	}

	public void setReportFormat(ReportFormat reportFormat) {
		this.reportFormat = reportFormat;
	}

	public TimeZone getUserTimeZone() {
		return userTimeZone;
	}

	public void setUserTimeZone(TimeZone userTimeZone) {
		this.userTimeZone = userTimeZone;
	}

	public String getReportName() {
		return reportName;
	}

	public void setReportName(String reportName) {
		this.reportName = reportName;
	}

	public DateRangeBoundary getScheduledReportFromDate() {
		return scheduledReportFromDate;
	}

	public void setScheduledReportFromDate(DateRangeBoundary scheduledReportFromDate) {
		this.scheduledReportFromDate = scheduledReportFromDate;
	}

	public DateRangeBoundary getScheduledReportToDate() {
		return scheduledReportToDate;
	}

	public void setScheduledReportToDate(DateRangeBoundary scheduledReportToDate) {
		this.scheduledReportToDate = scheduledReportToDate;
	}

	public Integer getDaysToKeepCompletedReports() {
		return daysToKeepCompletedReports;
	}

	public void setDaysToKeepCompletedReports(Integer daysToKeepCompletedReports) {
		this.daysToKeepCompletedReports = daysToKeepCompletedReports;
	}

}
