package gov.va.med.ccht.model.qir;

import java.util.Locale;

import gov.va.med.fw.ui.model.TermType;

public enum QIRStatusTypeEnum {

	Null,
	New,
	Agreed,
	Approved,
	Closed,
	Replied,
	Withdrawn;
	
	public static QIRStatusTypeEnum toEnum(TermType tt) {

		if (tt == null) {
			return Null;
		}

		QIRStatusType type = new QIRStatusType();
		type.setName(tt.getLabel());
		
		return toEnum(type);
	}

	public static QIRStatusTypeEnum toEnum(QIRStatusType type) {
		
		if (type == null) {
			return Null;
		}
		
		switch (type.getName().toUpperCase(Locale.ENGLISH)) {
		case "NEW":
			return New;
		case "AGREED":
			return Agreed;
		case "APPROVED":
			return Approved;
		case "CLOSED":
			return Closed;
		case "REPLIED":
			return Replied;
		case "WITHDRAWN":
			return Withdrawn;
		default:
			return Null;
		}
	}

}