package gov.va.med.ccht.model.qir;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

public class QIRSearchResult implements Serializable {

	private static final long serialVersionUID = 4822547703611462815L;
	
	public String id;
	public String dmpQirType;
	public String qirType;
	public String qirStatusType;
	public String visn;
	public String facilityCode;
	public String facility;
	public String deviceType;
	public String vendor;
	public Date submittedDate;
	public String submittedDateAsString;
	
	public String complaint;
	public String headline;
	public String submittedBy;
	public String submittedByName;
	public String attachmentCount;
	public String hasAttachments = "false";
	public String facilityNumAndName="";
	
	public String isDmpIssue;
	public String version;
	
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getQirType() {
		return qirType;
	}
	public void setQirType(String qirType) {
		this.qirType = qirType;
	}
	public String getQirStatusType() {
		return qirStatusType;
	}
	public void setQirStatusType(String qirStatusType) {
		this.qirStatusType = qirStatusType;
	}
	public String getVisn() {
		return visn;
	}
	public void setVisn(String visn) {
		this.visn = visn;
	}
	public String getFacilityCode() {
		return facilityCode;
	}
	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}
	public String getSubmittedBy() {
		return submittedBy;
	}
	public void setSubmittedBy(String submittedBy) {
		this.submittedBy = submittedBy;
	}
	public String getFacility() {
		return facility;
	}
	public void setFacility(String facility) {
		this.facility = facility;
	}
	public String getDeviceType() {
		return deviceType;
	}
	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}
	public String getVendor() {
		return vendor;
	}
	public void setVendor(String vendor) {
		this.vendor = vendor;
	}
	public Date getSubmittedDate() {
		return submittedDate;
	}
	public void setSubmittedDate(Date submittedDate) {
		this.submittedDate = submittedDate;
	}
	
	public String getSubmittedDateAsString() {
		return submittedDateAsString;
	}
	public void setSubmittedDateAsString(String submittedDateAsString) {
		this.submittedDateAsString = submittedDateAsString;
	}
	public String getComplaint() {
		return complaint;
	}
	public void setComplaint(String complaint) {
		this.complaint = complaint;
	}
	public String getHeadline() {
		return headline;
	}
	public void setHeadline(String headline) {
		this.headline = headline;
	}
	public String getSubmittedByName() {
		return submittedByName;
	}
	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}
	public String getAttachmentCount() {
		return attachmentCount;
	}
	public void setAttachmentCount(String attachmentCount) {
		this.attachmentCount = attachmentCount;
	}
	public String getHasAttachments() {
		return hasAttachments;
	}
	public String getFacilityNumAndName() {
		if(StringUtils.isNotEmpty(this.facilityCode))
		{
			facilityNumAndName=this.facilityCode;
		}
		if(StringUtils.isNotEmpty(this.facility))
		{
			this.facilityNumAndName=facilityNumAndName+" "+this.facility;
		}
		return this.facilityNumAndName;
	}
	public void setFacilityNumAndName(String facilityNumAndName) {
		this.facilityNumAndName = facilityNumAndName;
	}
	public void setHasAttachments(String hasAttachments) {
		this.hasAttachments = hasAttachments;
	}
	public String getIsDmpIssue() {
		return isDmpIssue;
	}
	public void setIsDmpIssue(String isDmpIssue) {
		this.isDmpIssue = isDmpIssue;
	}
	public String getDmpQirType() {
		return dmpQirType;
	}
	public void setDmpQirType(String dmpQirType) {
		this.dmpQirType = dmpQirType;
	}
	public String getVersion() {
		return version;
	}
	public void setVersion(String version) {
		this.version = version;
	}
	
	
}
