/**
 * 
 */
package gov.va.med.ccht.model.qir;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.hibernate.annotations.Formula;

import gov.va.med.ccht.model.CCHTAuditFields;

/**
 * @author DNS
 *
 */
@Entity
@Table(schema = "qir", name = "QIR_REMARKS")
public class QIRRemarks extends CCHTAuditFields implements Comparable<QIRRemarks> {

	private Long id;
	private QIR qir = null;
	private Date date = null;
	@NotNull
	@Size(min = 0, max = 2000)
	private String remarks = null;
	
	private String submittedByName = null;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name="QIR_REMARK_ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@ManyToOne
	@JoinColumn(name = "QIR_ID")
	public QIR getQir() {
		return qir;
	}

	public void setQir(QIR qir) {
		this.qir = qir;
	}

	@Column(name="REMARK_DATE")
	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	@Column(name="REMARK_TEXT")
	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")
	public String getSubmittedByName() {
		return submittedByName;
	}

	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}

	@Override
	public int compareTo(QIRRemarks o) {
		if (o != null) {
			QIRRemarks other = (QIRRemarks) o;
			Date otherDate = other.getDate();
			if (otherDate == null || date == null)
				return 0; // no date not an expected scenario
			return date.compareTo(otherDate);
		}
		return 0;
	}
}
