package gov.va.med.ccht.model.jobs;

import java.io.Serializable;

public class QuartzTriggerId implements Serializable {
    
    private static final long serialVersionUID = 3679697832580739883L;
    protected String triggerName;
    protected String triggerGroup;

    public QuartzTriggerId() {
        
    }

    public QuartzTriggerId(String triggerName, String triggerGroup) {
        this.triggerName = triggerName;
        this.triggerGroup = triggerGroup;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((triggerGroup == null) ? 0 : triggerGroup.hashCode());
        result = prime * result + ((triggerName == null) ? 0 : triggerName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QuartzTriggerId other = (QuartzTriggerId) obj;
        if (triggerGroup == null) {
            if (other.triggerGroup != null)
                return false;
        } else if (!triggerGroup.equals(other.triggerGroup))
            return false;
        if (triggerName == null) {
            if (other.triggerName != null)
                return false;
        } else if (!triggerName.equals(other.triggerName))
            return false;
        return true;
    }

    
}
