package gov.va.med.ccht.model.jobs;

import java.io.Serializable;

public class QuartzJobId  implements Serializable {
    
    private static final long serialVersionUID = 4775125715034404380L;
    protected String jobName;
    protected String jobGroup;

    public QuartzJobId() {
        
    }

    public QuartzJobId(String jobName, String jobGroup) {
        this.jobName = jobName;
        this.jobGroup = jobGroup;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((jobGroup == null) ? 0 : jobGroup.hashCode());
        result = prime * result + ((jobName == null) ? 0 : jobName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QuartzJobId other = (QuartzJobId) obj;
        if (jobGroup == null) {
            if (other.jobGroup != null)
                return false;
        } else if (!jobGroup.equals(other.jobGroup))
            return false;
        if (jobName == null) {
            if (other.jobName != null)
                return false;
        } else if (!jobName.equals(other.jobName))
            return false;
        return true;
    }
    
    

}
