package gov.va.med.ccht.model.common;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.Lookup;

@Entity
@Table(schema="dbo", name="VISN")
public class SimpleVisn implements Lookup {

	public static final SimpleVisn ALL_VISNS = new SimpleVisn("All VISNs");
	public static final SimpleVisn NO_VISN = new SimpleVisn("No VISN");

	private Integer id;
	private String name;
	
	public SimpleVisn () { super(); }
	
	private SimpleVisn (String name) { 
		super(); this.name = name;
	}
	
	@Id
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
	@Column(name="VISN_ID")
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}
	
	@Column(name = "VISN_Name",  length = 10, nullable = false, columnDefinition = "char")
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@Transient
	public String getCode() {
		return name;
	}
	@Transient
	public String getDescription() {
		return name;
	}
}
