package gov.va.med.ccht.model.common;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

@Entity
@Table(schema="dbo", name="Facilities") 
public class SimpleFacility implements Lookup, Comparable<SimpleFacility> {

	public static final SimpleFacility ALL_FACILITIES = new SimpleFacility("All Facilities");

	private Integer id;
	private String name;
	private SimpleVisn visn;
	private String stationNumber;

	public SimpleFacility() {
		super();
	}

	private SimpleFacility(String name) {
		super();
		this.name = name;
		this.stationNumber = name;
	}
	
	@Id
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY) 
	@Column(name = "ID", unique = true, nullable = false)
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	@Column(name = "FACILITY_NAME")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@ManyToOne
	@JoinColumn(name = "VISN_ID")
	public SimpleVisn getVisn() {
		return visn;
	}

	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}

	@Column(name = "FACILITY_ID")
	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	@Transient
	public String getCode() {
		return stationNumber;
	}

	@Transient
	public String getDescription() {
		String desc = visn == null ? "" : visn.getName();
		if (StringUtils.isNotEmpty(stationNumber)) {
			desc = desc + " Facility " + stationNumber;
		} 
		desc = desc + " " + name;
		return desc.trim();
	}

	@Transient
	private Integer getVisnId() {
		return visn == null ? 0 : visn.getId();
	}

	public int compareTo(SimpleFacility o) {
		if (o == null)
			return 0;
		int c = getStationNumber().compareTo(o.getStationNumber());
		if (c == 0) {
			return (stationNumber + name).compareTo(o.stationNumber + o.name);
		} else {
			return c;
		}
	}

	public String toString() {
		return "VISN " + visn.getId() + " Facility " + stationNumber + " " + name;
	}
}
