package gov.va.med.ccht.model.common;

import java.io.Serializable;
import java.util.Date;

import gov.va.med.fw.util.DateUtils;

public class ReportWeek implements Serializable {

	private static final long serialVersionUID = -5760010015382377216L;
	private Date startDate;
	private Date endDate;
	
	public ReportWeek() {
		super();
	}
	public ReportWeek(Date startDate, Date endDate) {
		super();
		this.startDate = startDate;
		this.endDate = endDate;
	}
	
	public Date getStartDate() {
		return startDate;
	}
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	public Date getEndDate() {
		return endDate;
	}
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	public String toString() {
		return DateUtils.format(startDate, null) + " " + DateUtils.format(endDate, null);
	}
}
