package gov.va.med.ccht.model.common;

import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.fw.model.lookup.AbstractLookup;

/**
 * @author DNS
 *
 */
@Entity
@Table(schema="dbo", name="MEDICAL_DEVICE_MODEL_TYPE")
@AttributeOverride(name = "id", column = @Column(name = "ID"))
public class DeviceType extends AbstractLookup {

	private static final long serialVersionUID = 1408398326825423566L;

	public static final String NULL_DEVICE_NAME = "{none}";

	private Long id;
	private Vendor vendor;
	
	@Id
	@Column(name = "ID")
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	public Long getId() {
		return this.id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}
	
	@ManyToOne(targetEntity=Vendor.class)
	@JoinColumn(name="VENDOR_ID")
	public Vendor getVendor() {
		return vendor;
	}
	public void setVendor(Vendor vendor) {
		this.vendor = vendor;
	}
	
	public String toString()
	{
		return getName();
	}
}
