package gov.va.med.ccht.model.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

import gov.va.med.ccht.model.report.ReportParameters;
import gov.va.med.fw.util.DateUtils;

public class DIReportParameters extends ReportParameters { //AbstractKeyedEntity {
	
	private static final long serialVersionUID = -4797684192473270806L;
	
	private String reportSummaryType;
	private ReportWeek reportWeek;
	private SimpleVisn visn;
	private Boolean allVisns = false;
	private Facility facility;
	private Boolean allFacilities = false;
	private String subTotalType;	//enum
	private Boolean allDeviceStatuses = false;
	
	public Map<String, Object> getParameterMap() {
		
		SimpleDateFormat sdf = new SimpleDateFormat(DateUtils.MMDDYYYY);
		if (getUserTimeZone() != null) {
			sdf.setTimeZone(getUserTimeZone());
			// map.put("userTimeZone", userTimeZone.getID());
		}
		
		Map<String, Object> map = super.getParameterMap();
		// common parameters
		map.put("reportSummaryType", reportSummaryType);
		map.put("subTotalType", subTotalType);
		//map.put("reportWeek", reportWeek);
		
		if (reportWeek != null) {
			map.put("fromDateStr", sdf.format(reportWeek.getStartDate()));
			map.put("toDateStr", sdf.format(reportWeek.getEndDate()));		
		}
		else if (getFromDate() == null && getToDate() == null && getAsOfDate() == null) {
			map.put("asOfDateStr", sdf.format(new Date()));			
		}

		map.put("visn", getVisn() == null ? "All VISNs" : getVisn().getName());
		map.put("facility", getFacility() == null ? "All Facilities" : getFacility().getDescription());
		
		return map;
	}
	
	public String getReportSummaryType() {
		return reportSummaryType;
	}
	public void setReportSummaryType(String reportSummaryType) {
		this.reportSummaryType = reportSummaryType;
	}
	public ReportWeek getReportWeek() {
		return reportWeek;
	}
	public void setReportWeek(ReportWeek reportWeek) {
		this.reportWeek = reportWeek;
	}
	public SimpleVisn getVisn() {
		return visn;
	}
	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}
	public Facility getFacility() {
		return facility;
	}
	public void setFacility(Facility facility) {
		this.facility = facility;
	}
	public String getSubTotalType() {
		return subTotalType;
	}
	public void setSubTotalType(String subTotalType) {
		this.subTotalType = subTotalType;
	}
	public Boolean getAllVisns() {
		return allVisns;
	}
	public void setAllVisns(Boolean allVisns) {
		this.allVisns = allVisns;
	}
	public Boolean getAllFacilities() {
		return allFacilities;
	}
	public void setAllFacilities(Boolean allFacilities) {
		this.allFacilities = allFacilities;
	}
	public Boolean getAllDeviceStatuses() {
		return allDeviceStatuses;
	}
	public void setAllDeviceStatuses(Boolean allDeviceStatuses) {
		this.allDeviceStatuses = allDeviceStatuses;
	}
}
