package gov.va.med.ccht.model.coc;
import java.text.DecimalFormat;

import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

public class CategoryOfCareRecord {

	private String columnName;
	private String rowName;
	private String name; // vendor name
	private String visnId;
	
	private String nicPercentTotal; // Non-institutionalized Care
	private String niclrPercentTotal; // Non-institutionalized Care low response
	private String chronicCareMgntPercentTotal;
	private String acuteCareMgntPercentTotal;
	private String hpdpPercentTotal; //Health Promotion/Disease Prevention
	private String lowActLowIntPercentTotal; //Low Acuity / Low Intensity

	private int nic; // Non-institutionalized Care
	private int niclr; // Non-institutionalized Care low responder
	private int chronicCareMgnt;
	private int acuteCareMgnt;
	private int hpdp; //Health Promotion/Disease Prevention
	private int lowActLowInt; //Low Acuity / Low Intensity
	private int total;
	private int totalsTotal;
	
	private String nicPercent; // Non-institutionalized Care
	private String niclrPercent; // Non-institutionalized Care low responder
	private String chronicCareMgntPercent;
	private String acuteCareMgntPercent;
	private String hpdpPercent; //Health Promotion/Disease Prevention
	private String lowActLowIntPercent; //Low Acuity / Low Intensity
	
	public String getColumnName() {
		return columnName;
	}
	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}
	public String getRowName() {
		return rowName;
	}
	public void setRowName(String rowName) {
		this.rowName = rowName;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		// we currently have vendor names with Upper Case, Lower Case, and Numbers in the Database and will limit future entries to this.
		this.name = ESAPIValidator.validateStringInput(name, ESAPIValidationType.FacilitiesName_WhiteList);
	}
	public String getVisnId() {
		return visnId;
	}
	public void setVisnId(String visnId) {
		this.visnId = visnId;
	}
	public String getNicPercentTotal() {
		return nicPercentTotal;
	}
	public void setNicPercentTotal(String nicPercentTotal) {
		this.nicPercentTotal = nicPercentTotal;
	}
	public String getNiclrPercentTotal() {
		return niclrPercentTotal;
	}
	public void setNiclrPercentTotal(String niclrPercentTotal) {
		this.niclrPercentTotal = niclrPercentTotal;
	}
	public String getChronicCareMgntPercentTotal() {
		return chronicCareMgntPercentTotal;
	}
	public void setChronicCareMgntPercentTotal(String chronicCareMgntPercentTotal) {
		this.chronicCareMgntPercentTotal = chronicCareMgntPercentTotal;
	}
	public String getAcuteCareMgntPercentTotal() {
		return acuteCareMgntPercentTotal;
	}
	public void setAcuteCareMgntPercentTotal(String acuteCareMgntPercentTotal) {
		this.acuteCareMgntPercentTotal = acuteCareMgntPercentTotal;
	}
	public String getHpdpPercentTotal() {
		return hpdpPercentTotal;
	}
	public void setHpdpPercentTotal(String hpdpPercentTotal) {
		this.hpdpPercentTotal = hpdpPercentTotal;
	}
	public String getLowActLowIntPercentTotal() {
		return lowActLowIntPercentTotal;
	}
	public void setLowActLowIntPercentTotal(String lowActLowIntPercentTotal) {
		this.lowActLowIntPercentTotal = lowActLowIntPercentTotal;
	}
	public int getNic() {
		return nic;
	}
	public void setNic(int nic) {
		this.nic = nic;
	}
	public int getNiclr() {
		return niclr;
	}
	public void setNiclr(int niclr) {
		this.niclr = niclr;
	}
	public String getNicPercent() {
		return nicPercent;
	}
	public void setNicPercent(String nicPercent) {
		this.nicPercent = nicPercent;
	}
	public String getNiclrPercent() {
		return niclrPercent;
	}
	public void setNiclrPercent(String niclrPercent) {
		this.niclrPercent = niclrPercent;
	}
	public String getChronicCareMgntPercent() {
		return chronicCareMgntPercent;
	}
	public void setChronicCareMgntPercent(String chronicCareMgntPercent) {
		this.chronicCareMgntPercent = chronicCareMgntPercent;
	}
	public String getAcuteCareMgntPercent() {
		return acuteCareMgntPercent;
	}
	public void setAcuteCareMgntPercent(String acuteCareMgntPercent) {
		this.acuteCareMgntPercent = acuteCareMgntPercent;
	}
	public String getHpdpPercent() {
		return hpdpPercent;
	}
	public void setHpdpPercent(String hpdpPercent) {
		this.hpdpPercent = hpdpPercent;
	}
	public String getLowActLowIntPercent() {
		return lowActLowIntPercent;
	}
	public void setLowActLowIntPercent(String lowActLowIntPercent) {
		this.lowActLowIntPercent = lowActLowIntPercent;
	}
	public int getChronicCareMgnt() {
		return chronicCareMgnt;
	}
	public void setChronicCareMgnt(int chronicCareMgnt) {
		this.chronicCareMgnt = chronicCareMgnt;
	}
	public int getAcuteCareMgnt() {
		return acuteCareMgnt;
	}
	public void setAcuteCareMgnt(int acuteCareMgnt) {
		this.acuteCareMgnt = acuteCareMgnt;
	}
	public int getHpdp() {
		return hpdp;
	}
	public void setHpdp(int hpdp) {
		this.hpdp = hpdp;
	}
	public int getLowActLowInt() {
		return lowActLowInt;
	}
	public void setLowActLowInt(int lowActLowInt) {
		this.lowActLowInt = lowActLowInt;
	}
	public int getTotal() {
		return total;
	}
	
	/**
	 * Can only be set once all other data is set. is auto calculated once called.
	 */
	public void setTotal() {
		this.total = nic + niclr + chronicCareMgnt + acuteCareMgnt + hpdp + lowActLowInt;
	}
	public int getTotalsTotal() {
		return totalsTotal;
	}
	public void setTotalsTotal(int vendorTotalsTotal) {
		this.totalsTotal = vendorTotalsTotal;
	}
	public void calulateInvidualPercentColumns() {
		nicPercent = calculatePercent(nic,total);
		niclrPercent = calculatePercent(niclr,total);
		chronicCareMgntPercent = calculatePercent(chronicCareMgnt,total);
		acuteCareMgntPercent = calculatePercent(acuteCareMgnt,total);
		hpdpPercent = calculatePercent(hpdp,total);
		lowActLowIntPercent = calculatePercent(lowActLowInt,total);
	}
	private String calculatePercent(int part, int total) {
    	
    	float percent = (float)part/total;
    	
    	return String.valueOf(percent);
    }
}
