package gov.va.med.ccht.model.car;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.va.med.fw.util.DateUtils;

public class VendorCensusReportStatus  implements Serializable 
{
	private static final long serialVersionUID = -6463429701862778771L;
	private String vendorName = null;
	private Date startDate = null;
	private Date endDate = null;
	private String startDateAsString = null;
	private String endDateAsString = null;
	private Date dateLoaded = null;
	private String ackType = null;
	private Integer patientCount = null;
	private String status = null;
	private Date lastReportDate = null;
	private String lastReportDateAsString = null;
	
	public Date getLastReportDate() {
		return lastReportDate;
	}

	public void setLastReportDate(Date lastReport) {
		this.lastReportDate = lastReport;
	}
	public String getlastReportDateAsString()
	{
		if(lastReportDate == null)
		{
			return "";
		}
		else
		{
			SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYY);
			lastReportDateAsString = format.format(lastReportDate);
		}
		return lastReportDateAsString;
	}

	public void setStartDateAsString() {
		SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYYHHMMSS);
		startDateAsString = format.format(startDate);
	}

	public void setEndDateAsString() {
		SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYYHHMMSS);
		endDateAsString = format.format(endDate);
	}
	
	public void setStartDateAsString(String startDateAsString) {
		this.startDateAsString = startDateAsString;
	}

	public void setEndDateAsString(String endDateAsString) {
		this.endDateAsString = endDateAsString;
	}

	public String getStartDateAsString()
	{
		if(startDate == null)
		{
			return "";
		}
		else
		{
			SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYY);
			startDateAsString = format.format(startDate);
		}
		
		return startDateAsString;
	}
	
	public String getEndDateAsString()
	{
		if(endDate == null)
		{
			return "";
		}
		else
		{
			SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYY);			
			endDateAsString = format.format(endDate);
		}
		
		return endDateAsString;
	}
	
	public String getVendorName() 
	{
		return vendorName;
	}
	
	public void setVendorName(String vendorName) 
	{
		this.vendorName = vendorName;
	}
	
	public Date getStartDate() 
	{
		return startDate;
	}
	
	public void setStartDate(Date startDate) 
	{
		this.startDate = startDate;
	}
	
	public Date getEndDate() 
	{
		return endDate;
	}
	
	public void setEndDate(Date endDate)
	{
		this.endDate = endDate;
	}
	
	public Date getDateLoaded() 
	{
		return dateLoaded;
	}
	
	public void setDateLoaded(Date dateLoaded) 
	{
		this.dateLoaded = dateLoaded;
	}
	
	public String getAckType() 
	{
		return ackType;
	}
	
	public void setAckType(String ackType) 
	{
		this.ackType = ackType;
	}

	public Integer getPatientCount() 
	{
		return patientCount;
	}

	public void setPatientCount(Integer thePatientCount) 
	{
		if(thePatientCount != null)
		{
			this.patientCount = thePatientCount;
		}
		else
		{
			this.patientCount = 0;
		}
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Override
	public String toString() {
		return "VendorCensusReportStatus [vendorName=" + vendorName
				+ ", startDate=" + startDate + ", endDate=" + endDate
				+ ", startDateAsString=" + startDateAsString
				+ ", endDateAsString=" + endDateAsString + ", dateLoaded="
				+ dateLoaded + ", ackType=" + ackType + ", patientCount="
				+ patientCount + ", status=" + status + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((ackType == null) ? 0 : ackType.hashCode());
		result = prime * result
				+ ((dateLoaded == null) ? 0 : dateLoaded.hashCode());
		result = prime * result + ((endDate == null) ? 0 : endDate.hashCode());
		result = prime * result
				+ ((endDateAsString == null) ? 0 : endDateAsString.hashCode());
		result = prime * result
				+ ((patientCount == null) ? 0 : patientCount.hashCode());
		result = prime * result
				+ ((startDate == null) ? 0 : startDate.hashCode());
		result = prime
				* result
				+ ((startDateAsString == null) ? 0 : startDateAsString
						.hashCode());
		result = prime * result + ((status == null) ? 0 : status.hashCode());
		result = prime * result
				+ ((vendorName == null) ? 0 : vendorName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		VendorCensusReportStatus other = (VendorCensusReportStatus) obj;
		if (ackType == null) {
			if (other.ackType != null)
				return false;
		} else if (!ackType.equals(other.ackType))
			return false;
		if (dateLoaded == null) {
			if (other.dateLoaded != null)
				return false;
		} else if (!dateLoaded.equals(other.dateLoaded))
			return false;
		if (endDate == null) {
			if (other.endDate != null)
				return false;
		} else if (!endDate.equals(other.endDate))
			return false;
		if (endDateAsString == null) {
			if (other.endDateAsString != null)
				return false;
		} else if (!endDateAsString.equals(other.endDateAsString))
			return false;
		if (patientCount == null) {
			if (other.patientCount != null)
				return false;
		} else if (!patientCount.equals(other.patientCount))
			return false;
		if (startDate == null) {
			if (other.startDate != null)
				return false;
		} else if (!startDate.equals(other.startDate))
			return false;
		if (startDateAsString == null) {
			if (other.startDateAsString != null)
				return false;
		} else if (!startDateAsString.equals(other.startDateAsString))
			return false;
		if (status == null) {
			if (other.status != null)
				return false;
		} else if (!status.equals(other.status))
			return false;
		if (vendorName == null) {
			if (other.vendorName != null)
				return false;
		} else if (!vendorName.equals(other.vendorName))
			return false;
		return true;
	}

	
}
