package gov.va.med.ccht.model.car;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

public class CensusActivityVisnRecord implements Comparable<CensusActivityVisnRecord>, Serializable {

	private static final long serialVersionUID = 1379373488191465783L;
	
	private Integer visnId = 0;
	private Integer patientTotals = 0;
	
	private Map<String, Integer> totalsMap = new HashMap<String, Integer>();
	
	// limited to upper case, lower case, and numbers
	private String facilityId = null;
	//limited to upper case, lower case, numbers, dash, period, open/close paren, comma, forward slash
	private String facilityName = null;
	// limited to upper case, lower case, and numbers
	private String visnName = null;
	// limited to upper case, lower case, and numbers
	private String vendorName = null;

	public Integer getVisnId() {
	
		return visnId;
	}

	public void setVisnId(Integer visnId) {
		this.visnId = visnId;
	}

	public Integer getPatientTotals() {	
		
		return patientTotals;
	}

	public void setPatientTotals(Integer patientTotals) {
		
		if(patientTotals != null)
		{
			this.patientTotals = patientTotals;
		}
		else
		{
			patientTotals = 0;
		}
	}
	
	public Integer getTotal() {
		int total = 0;
		// Loop through the hashmap and get the totals for each 
		for(String key: totalsMap.keySet()) {
			if(totalsMap != null) {
				total += totalsMap.get(key);
			}
		}
		return total;
	}

	public void setModalityTotal(String modalityName, Integer total) {
		totalsMap.put(modalityName, total);
	}
	
	public Map<String, Integer> getTotalsMap() {
		return totalsMap;
	}
	
	public String getFacilityId() {
		return facilityId;
	}
	
	public void setFacilityId(String facilityId) {
		this.facilityId = ESAPIValidator.validateStringInput(facilityId, ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList);
	}
	
	public String getFacilityName() {
		return facilityName;
	}
	
	public void setFacilityName(String facilityName) {
		this.facilityName = ESAPIValidator.validateStringInput(facilityName, ESAPIValidationType.FacilitiesName_WhiteList);
	}

	public String getVisnName() {
		return visnName;
	}

	public void setVisnName(String visnName) {
		this.visnName = ESAPIValidator.validateStringInput(visnName, ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList);;
	}	
	
	public String getVendorName() {
		return vendorName;
	}

	public void setVendorName(String vendorName) {
		this.vendorName = ESAPIValidator.validateStringInput(vendorName, ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList);
	}
	
	public void add(CensusActivityVisnRecord recordToAdd)
	{
		patientTotals += recordToAdd.getPatientTotals();
		for(String key: totalsMap.keySet()) {
			// Keys should be the same regardless because these are being pulled at the same time.
			// Therefore, modalities should be the same.
			totalsMap.put(key, totalsMap.get(key) + recordToAdd.totalsMap.get(key));
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((facilityId == null) ? 0 : facilityId.hashCode());
		result = prime * result + ((patientTotals == null) ? 0 : patientTotals.hashCode());
		result = prime * result + ((vendorName == null) ? 0 : vendorName.hashCode());
		result = prime * result + ((visnId == null) ? 0 : visnId.hashCode());
		result = prime * result + ((visnName == null) ? 0 : visnName.hashCode());
		for(String key: totalsMap.keySet()) {
			result = prime * result + totalsMap.get(key);
		}
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CensusActivityVisnRecord other = (CensusActivityVisnRecord) obj;

		for(String key: totalsMap.keySet()) {
			if(totalsMap.get(key) != other.totalsMap.get(key)) {
				return false;
			}
		}
		
		if (facilityId == null) {
			if (other.facilityId != null)
				return false;
		} else if (!facilityId.equals(other.facilityId))
			return false;
		if (facilityName == null) {
			if (other.facilityName != null)
				return false;
		} else if (!facilityName.equals(other.facilityName))
			return false;
		if (patientTotals == null) {
			if (other.patientTotals != null)
				return false;
		} else if (!patientTotals.equals(other.patientTotals))
			return false;
		if (vendorName == null) {
			if (other.vendorName != null)
				return false;
		} else if (!vendorName.equals(other.vendorName))
			return false;
		if (visnId == null) {
			if (other.visnId != null)
				return false;
		} else if (!visnId.equals(other.visnId))
			return false;
		if (visnName == null) {
			if (other.visnName != null)
				return false;
		} else if (!visnName.equals(other.visnName))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "CensusActivityVisnRecord [facilityId=" + facilityId
				+ ", facilityName=" + facilityName
				+ ", patientTotals=" + patientTotals
				+ ", vendorName=" + vendorName
				+ ", visnId=" + visnId
				+ ", visnName=" + visnName + "]";
	}
	
	@Override
	public int compareTo(CensusActivityVisnRecord other) {
		// Sorting is used for display and is based on the name of the facility instead of id.
		return this.facilityName.compareTo(other.facilityName);
	}
}
