package gov.va.med.ccht.model.car;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

public class CensusActivitySubTotalRecord implements Serializable 
{
	private static final long serialVersionUID = 6335767098466042024L;
	
	private String modalityName;
	private Map<String, Integer> totalsMap = new HashMap<String, Integer>();
	
	public String getModalityName()
	{
		return modalityName;
	}
	
	public void setModalityName(String modalityName)
	{
		this.modalityName = ESAPIValidator.validateStringInput(modalityName, ESAPIValidationType.ModalityDescription_WhiteList);
	}
	
	public Integer getTotal() 
	{
		int total = 0;
		// Loop through the hashmap and get the totals for each
		for(String key: totalsMap.keySet()) {
			if(totalsMap != null) {
				total += totalsMap.get(key);
			}
		}
		return total;
	}

	public void setVendorTotal(String vendorName, Integer total) {
		totalsMap.put(vendorName, total);
	}
	
	public Map<String, Integer> getTotalsMap() {
		return totalsMap;
	}

	@Override
	public String toString() {
		String totalString = "total = " + getTotal();
		for(String key: totalsMap.keySet()) {
			Integer vendorTotal = totalsMap.get(key);
			if(vendorTotal == null) {
				vendorTotal = 0;
			}
			totalString += String.format(", %s = %s ", key, vendorTotal);
		}
		
		return "CensusActivitySubTotalRecord [" + totalString +"]";
	}
}
