package gov.va.med.ccht.model.car;

import java.io.Serializable;

public class CensusActivityReportResult implements Serializable 
{
	private static final long serialVersionUID = -4863417605454143048L;
	
	private String nationalTotalsTitle;
	private Integer totalPatients; 
	private Integer messagingTotal; 
	private Integer messagingByDevice; 
	private Integer messagingByIVR; 
	private Integer messagingByBrowser; 
	private Integer messagingByNotYetAssigned; 
	private Integer peripheralMeasurements; 
	private Integer videoTotal; 
	private Integer cellularModemTransmission; 
	private Integer satelliteTransmission; 
	private Integer digitalImageCapture;
	
	private Integer totalForSelectedModality;
	
	
	public String getNationalTotalsTitle()
	{		
		return nationalTotalsTitle;
	}
	
	public void setNationalTotalsTitle(String nationalTotalsTitle) 
	{
		this.nationalTotalsTitle = nationalTotalsTitle;
	}
	
	public Integer getTotalPatients() 
	{
		if(totalPatients != null)
		{
			return totalPatients;
		}
		else
		{
			return 0;
		}
	}
	
	public void setTotalPatients(Integer totalPatients) 
	{
		this.totalPatients = totalPatients;
	}
	
	public Integer getMessagingTotal() 
	{
		if(messagingTotal != null)
		{
			return messagingTotal;
		}
		else
		{
			return 0;
		}
	}
	
	public void setMessagingTotal(Integer messagingTotal) 
	{
		this.messagingTotal = messagingTotal;
	}
	
	public Integer getMessagingByDevice() 
	{
		if(messagingByDevice !=  null)
		{
			return messagingByDevice;
		}
		else
		{
			return 0;
		}
	}
	
	public void setMessagingByDevice(Integer messagingByDevice) 
	{
		this.messagingByDevice = messagingByDevice;
	}
	
	public Integer getMessagingByIVR() 
	{
		if(messagingByIVR != null)
		{
			return messagingByIVR;
		}
		else
		{
			return 0;
		}
	}
	
	public void setMessagingByIVR(Integer messagingByIVR) 
	{
		this.messagingByIVR = messagingByIVR;
	}
	
	public Integer getMessagingByBrowser() 
	{
		if(messagingByBrowser != null)
		{
			return messagingByBrowser;
		}
		else
		{
			return 0;
		}
	}
	
	public void setMessagingByBrowser(Integer messagingByBrowser) 
	{		
		this.messagingByBrowser = messagingByBrowser;
	}
	
	public Integer getMessagingByNotYetAssigned() 
	{
		if(messagingByNotYetAssigned != null)
		{
			return messagingByNotYetAssigned;
		}
		else
		{
			return 0;
		}
	}
	
	public void setMessagingByNotYetAssigned(Integer messagingByNotYetAssigned) 
	{
		this.messagingByNotYetAssigned = messagingByNotYetAssigned;
	}
	
	public Integer getPeripheralMeasurements() 
	{
		if(peripheralMeasurements != null)
		{
			return peripheralMeasurements;
		}
		else
		{
			return 0;
		}
	}
	
	public void setPeripheralMeasurements(Integer peripheralMeasurements) 
	{
		this.peripheralMeasurements = peripheralMeasurements;
	}
	
	public Integer getVideoTotal() 
	{
		if(videoTotal != null)
		{
			return videoTotal;
		}
		else
		{
			return 0;
		}
	}
	
	public void setVideoTotal(Integer videoTotal) 
	{
		this.videoTotal = videoTotal;
	}
	
	public Integer getCellularModemTransmission() 
	{
		if(cellularModemTransmission != null)
		{
			return cellularModemTransmission;
		}
		else
		{
			return 0;
		}
	}
	
	public void setCellularModemTransmission(Integer cellularModemTransmission) 
	{
		this.cellularModemTransmission = cellularModemTransmission;
	}
	
	public Integer getSatelliteTransmission() 
	{
		if(satelliteTransmission != null)
		{
			return satelliteTransmission;
		}
		else
		{
			return 0;
		}
	}
	
	public void setSatelliteTransmission(Integer satelliteTransmission) 
	{
		this.satelliteTransmission = satelliteTransmission;
	}
	
	public Integer getDigitalImageCapture() 
	{
		if(digitalImageCapture != null)
		{
			return digitalImageCapture;
		}
		else
		{
			return 0;
		}
	}
	
	public void setDigitalImageCapture(Integer digitalImageCapture) 
	{
		this.digitalImageCapture = digitalImageCapture;
	}
	
	public Integer getTotalForSelectedModality() 
	{
		if(totalForSelectedModality !=  null)
		{
			return totalForSelectedModality;
		}
		else
		{
			return 0;
		}
	}

	public void setTotalForSelectedModality(Integer totalForSelectedModality) 
	{
		this.totalForSelectedModality = totalForSelectedModality;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((cellularModemTransmission == null) ? 0
						: cellularModemTransmission.hashCode());
		result = prime
				* result
				+ ((digitalImageCapture == null) ? 0 : digitalImageCapture
						.hashCode());
		result = prime
				* result
				+ ((messagingByBrowser == null) ? 0 : messagingByBrowser
						.hashCode());
		result = prime
				* result
				+ ((messagingByDevice == null) ? 0 : messagingByDevice
						.hashCode());
		result = prime * result
				+ ((messagingByIVR == null) ? 0 : messagingByIVR.hashCode());
		result = prime
				* result
				+ ((messagingByNotYetAssigned == null) ? 0
						: messagingByNotYetAssigned.hashCode());
		result = prime * result
				+ ((messagingTotal == null) ? 0 : messagingTotal.hashCode());
		result = prime
				* result
				+ ((nationalTotalsTitle == null) ? 0 : nationalTotalsTitle
						.hashCode());
		result = prime
				* result
				+ ((peripheralMeasurements == null) ? 0
						: peripheralMeasurements.hashCode());
		result = prime
				* result
				+ ((satelliteTransmission == null) ? 0 : satelliteTransmission
						.hashCode());
		result = prime
				* result
				+ ((totalForSelectedModality == null) ? 0
						: totalForSelectedModality.hashCode());
		result = prime * result
				+ ((totalPatients == null) ? 0 : totalPatients.hashCode());
		result = prime * result
				+ ((videoTotal == null) ? 0 : videoTotal.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CensusActivityReportResult other = (CensusActivityReportResult) obj;
		if (cellularModemTransmission == null) {
			if (other.cellularModemTransmission != null)
				return false;
		} else if (!cellularModemTransmission
				.equals(other.cellularModemTransmission))
			return false;
		if (digitalImageCapture == null) {
			if (other.digitalImageCapture != null)
				return false;
		} else if (!digitalImageCapture.equals(other.digitalImageCapture))
			return false;
		if (messagingByBrowser == null) {
			if (other.messagingByBrowser != null)
				return false;
		} else if (!messagingByBrowser.equals(other.messagingByBrowser))
			return false;
		if (messagingByDevice == null) {
			if (other.messagingByDevice != null)
				return false;
		} else if (!messagingByDevice.equals(other.messagingByDevice))
			return false;
		if (messagingByIVR == null) {
			if (other.messagingByIVR != null)
				return false;
		} else if (!messagingByIVR.equals(other.messagingByIVR))
			return false;
		if (messagingByNotYetAssigned == null) {
			if (other.messagingByNotYetAssigned != null)
				return false;
		} else if (!messagingByNotYetAssigned
				.equals(other.messagingByNotYetAssigned))
			return false;
		if (messagingTotal == null) {
			if (other.messagingTotal != null)
				return false;
		} else if (!messagingTotal.equals(other.messagingTotal))
			return false;
		if (nationalTotalsTitle == null) {
			if (other.nationalTotalsTitle != null)
				return false;
		} else if (!nationalTotalsTitle.equals(other.nationalTotalsTitle))
			return false;
		if (peripheralMeasurements == null) {
			if (other.peripheralMeasurements != null)
				return false;
		} else if (!peripheralMeasurements.equals(other.peripheralMeasurements))
			return false;
		if (satelliteTransmission == null) {
			if (other.satelliteTransmission != null)
				return false;
		} else if (!satelliteTransmission.equals(other.satelliteTransmission))
			return false;
		if (totalForSelectedModality == null) {
			if (other.totalForSelectedModality != null)
				return false;
		} else if (!totalForSelectedModality
				.equals(other.totalForSelectedModality))
			return false;
		if (totalPatients == null) {
			if (other.totalPatients != null)
				return false;
		} else if (!totalPatients.equals(other.totalPatients))
			return false;
		if (videoTotal == null) {
			if (other.videoTotal != null)
				return false;
		} else if (!videoTotal.equals(other.videoTotal))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "CensusActivityReportResult [cellularModemTransmission="
				+ cellularModemTransmission + ", digitalImageCapture="
				+ digitalImageCapture + ", messagingByBrowser="
				+ messagingByBrowser + ", messagingByDevice="
				+ messagingByDevice + ", messagingByIVR=" + messagingByIVR
				+ ", messagingByNotYetAssigned=" + messagingByNotYetAssigned
				+ ", messagingTotal=" + messagingTotal
				+ ", nationalTotalsTitle=" + nationalTotalsTitle
				+ ", peripheralMeasurements=" + peripheralMeasurements
				+ ", satelliteTransmission=" + satelliteTransmission
				+ ", totalForSelectedModality=" + totalForSelectedModality
				+ ", totalPatients=" + totalPatients + ", videoTotal="
				+ videoTotal + "]";
	}	
	
}
