/**
 * 
 */
package gov.va.med.ccht.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * @author DNS
 *
 */
@Entity
@Table(schema="ht", name="USER_PREFERENCE")
public class UserPreference extends CCHTAuditFields {

	public static final long serialVersionUID = -1372518651309869416L;
	public static final String MULTIPLE_WINDOWS = "Multiple Windows";
	public static final String MAX_OPEN_WINDOWS = "Maximum Open Windows";
	public static final String APP_WINDOW_HEIGHT = "Application Window Height";
	public static final String APP_WINDOW_WIDTH = "Application Window Width";
		
	private Long id;
	private User user;
	private String name;
	private String value;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "USER_PREFERENCE_ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	@ManyToOne
	@JoinColumn(name="APP_USER_ID")
	public User getUser() {
		return user;
	}
	public void setUser(User user) {
		this.user = user;
	}
	
	@Column(name="NAME")
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	@Column(name="PREF_VALUE")
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}	
}
